/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device.reader;

import android.app.Activity;
import android.content.res.Configuration;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import com.unity3d.services.core.configuration.ExperimentsReader;
import com.unity3d.services.core.device.reader.IHdrInfoReader;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class HdrInfoReader
implements IHdrInfoReader {
    private final SDKMetricsSender _sdkMetricsSender = (SDKMetricsSender)Utilities.getService(SDKMetricsSender.class);
    private static final AtomicBoolean _hdrMetricsCaptured = new AtomicBoolean(false);
    private static volatile HdrInfoReader _instance;

    private HdrInfoReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HdrInfoReader getInstance() {
        if (_instance != null) return _instance;
        Class<HdrInfoReader> clazz = HdrInfoReader.class;
        synchronized (HdrInfoReader.class) {
            if (_instance != null) return _instance;
            _instance = new HdrInfoReader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    @Override
    public void captureHDRCapabilityMetrics(Activity activity, ExperimentsReader experimentsReader) {
        if (activity == null) {
            return;
        }
        if (!experimentsReader.getCurrentlyActiveExperiments().isCaptureHDRCapabilitiesEnabled()) {
            return;
        }
        if (_hdrMetricsCaptured.compareAndSet(false, true)) {
            ArrayList<Metric> hdrMetrics = new ArrayList<Metric>(5);
            int hasDolbyVision = 0;
            int hasHDR10 = 0;
            int hasHDR10Plus = 0;
            int hasHLG = 0;
            int isScreenHDR = 0;
            if (Build.VERSION.SDK_INT >= 24) {
                int[] types;
                Display display = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
                Display.HdrCapabilities hdrCapabilities = display.getHdrCapabilities();
                block6: for (int type : types = hdrCapabilities.getSupportedHdrTypes()) {
                    switch (type) {
                        case 1: {
                            hasDolbyVision = 1;
                            continue block6;
                        }
                        case 2: {
                            hasHDR10 = 1;
                            continue block6;
                        }
                        case 3: {
                            hasHLG = 1;
                            continue block6;
                        }
                        case 4: {
                            hasHDR10Plus = 1;
                        }
                    }
                }
                long maxAverage = Math.round(hdrCapabilities.getDesiredMaxAverageLuminance());
                long maxLum = Math.round(hdrCapabilities.getDesiredMaxLuminance());
                long minLum = Math.round(hdrCapabilities.getDesiredMinLuminance());
                hdrMetrics.add(new Metric("native_device_hdr_lum_max_average", maxAverage));
                hdrMetrics.add(new Metric("native_device_hdr_lum_max", maxLum));
                hdrMetrics.add(new Metric("native_device_hdr_lum_min", minLum));
                if (Build.VERSION.SDK_INT >= 26) {
                    Configuration configuration = activity.getResources().getConfiguration();
                    isScreenHDR = configuration.isScreenHdr() ? 1 : 0;
                }
            }
            hdrMetrics.add(new Metric("native_device_hdr_dolby_vision", hasDolbyVision));
            hdrMetrics.add(new Metric("native_device_hdr_hdr10", hasHDR10));
            hdrMetrics.add(new Metric("native_device_hdr_hdr10_plus", hasHDR10Plus));
            hdrMetrics.add(new Metric("native_device_hdr_hlg", hasHLG));
            hdrMetrics.add(new Metric("native_device_hdr_screen_hdr", isScreenHDR));
            this._sdkMetricsSender.sendMetrics(hdrMetrics);
        }
    }
}

