package com.unity3d.services

import android.content.Context
import com.unity3d.ads.IUnityAdsLoadListener
import com.unity3d.ads.IUnityAdsShowListener
import com.unity3d.ads.UnityAdsLoadOptions
import com.unity3d.ads.UnityAdsShowOptions
import com.unity3d.ads.core.configuration.AlternativeFlowReader
import com.unity3d.ads.core.domain.InitializeBoldSDK
import com.unity3d.ads.core.domain.LegacyLoadUseCase
import com.unity3d.ads.core.domain.LegacyShowUseCase
import com.unity3d.services.core.di.IServiceComponent
import com.unity3d.services.core.di.ServiceProvider.NAMED_SDK
import com.unity3d.services.core.di.get
import com.unity3d.services.core.di.inject
import com.unity3d.services.core.domain.task.EmptyParams
import com.unity3d.services.core.domain.task.InitializeSDK
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

/**
 * SDK Kotlin entry point
 */
object UnityAdsSDK : IServiceComponent {

    private val sdkScope: CoroutineScope by inject(NAMED_SDK)
    private val initializeSDK: InitializeSDK by inject()
    private val alternativeFlowReader: AlternativeFlowReader by inject()

    private val initializeBoldSDK: InitializeBoldSDK by inject()
    private val showBoldSDK: LegacyShowUseCase by inject()
    private val context: Context by inject()

    /**
     * Initialize the SDK
     */
    fun initialize() = sdkScope.launch {
        val isAlternativeFlowEnabled = alternativeFlowReader()
        if (isAlternativeFlowEnabled) {
            initializeBoldSDK()
        } else {
            initializeSDK(EmptyParams)
        }
    }

    fun load(placementId: String, loadOptions: UnityAdsLoadOptions, listener: IUnityAdsLoadListener?) = sdkScope.launch {
        val isAlternativeFlowEnabled = alternativeFlowReader()
        if (isAlternativeFlowEnabled) {
            val loadBoldSDK = get<LegacyLoadUseCase>()
            loadBoldSDK(context, placementId, loadOptions, listener)
        }
    }

    fun show(placementId: String, showOptions: UnityAdsShowOptions?, listener: IUnityAdsShowListener?) = sdkScope.launch {
        val isAlternativeFlowEnabled = alternativeFlowReader()
        if (isAlternativeFlowEnabled) {
            showBoldSDK(
                context = context,
                placement = placementId,
                unityAdsShowOptions = showOptions,
                unityShowListener = listener
            )
        }
    }

}