package com.unity3d.services

import com.unity3d.ads.BuildConfig

object UnityAdsConstants {

    object Messages {
        const val MSG_UNITY_BASE = "[Unity Ads] "
        const val MSG_INTERNAL_ERROR = "Internal error"
    }

    object Timeout {
        const val INIT_TIMEOUT_MS = 10000L
    }

    object RequestPolicy {
        const val RETRY_MAX_DURATION = 30000
        const val RETRY_WAIT_BASE = 30000
        const val RETRY_JITTER_PCT = 0.1f
        const val CONNECT_TIMEOUT_MS = 30000
        const val READ_TIMEOUT_MS = 30000
        const val WRITE_TIMEOUT_MS = 30000
        const val SHOULD_STORE_LOCALLY = false
    }

    object SharedFlow {
        const val REPLAY = 10
        const val EXTRA_CAPACITY = 10
    }

    object DefaultUrls {
        const val GATEWAY_URL = "http://gateway.unityads.unity3d.com/v1"
        const val AD_PLAYER_QUERY_PARAMS = "?platform=android&"
    }

    object ClientInfo {
        const val SDK_VERSION = BuildConfig.VERSION_CODE
        const val SDK_VERSION_NAME = BuildConfig.VERSION_NAME
    }
}
