package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.model.OperationType
import com.unity3d.ads.gatewayclient.GatewayClient

class TriggerAndroidInitializationCompletedRequest(
    private val getInitializationCompletedRequest: GetInitializationCompletedRequest,
    private val getRequestPolicy: GetRequestPolicy,
    private val gatewayClient: GatewayClient,
) : TriggerInitializationCompletedRequest {
    override suspend fun invoke() {
        val initializationCompletedRequest = getInitializationCompletedRequest()
        val requestPolicy = getRequestPolicy()
       gatewayClient.request(
            request = initializationCompletedRequest,
            requestPolicy = requestPolicy,
            operationType = OperationType.INITIALIZATION_COMPLETED
        )
    }
}