package com.unity3d.ads.core.domain

import gateway.v1.InitializationResponseOuterClass.InitializationResponse
import com.unity3d.ads.core.data.repository.SessionRepository
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

internal class HandleAndroidGatewayInitializationResponse(
    private val triggerInitializationCompletedRequest: TriggerInitializationCompletedRequest,
    private val sessionRepository: SessionRepository,
    private val sdkScope: CoroutineScope
) : HandleGatewayInitializationResponse {
    override suspend fun invoke(response: InitializationResponse) {
        check(!response.hasError()) { response.error.errorText }

        sessionRepository.nativeConfiguration = response.nativeConfiguration
        if (response.hasUniversalRequestUrl() && !response.universalRequestUrl.isNullOrEmpty()) {
            sessionRepository.gatewayUrl = response.universalRequestUrl
        }

        if (response.triggerInitializationCompletedRequest) {
            sdkScope.launch {
                triggerInitializationCompletedRequest()
            }
        }
    }
}