package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.CampaignState
import gateway.v1.CampaignStateOuterClass

interface CampaignStateRepository {
    suspend fun updateState(opportunityId: ByteString, campaignState: CampaignState)
    suspend fun setShowTimestamp(opportunityId: ByteString)
    suspend fun getState(opportunityId: ByteString) : CampaignState?
    suspend fun removeState(opportunityId: ByteString)
    suspend fun getStates(): List<Pair<ByteString, CampaignState>>
    suspend fun setLoadTimestamp(opportunityId: ByteString)
    suspend fun getCampaignState(): CampaignStateOuterClass.CampaignState
}