package com.unity3d.ads.core.data.repository

import com.google.protobuf.ByteString
import com.unity3d.ads.core.data.model.CampaignState
import com.unity3d.ads.core.domain.GetSharedDataTimestamps
import gateway.v1.CampaignStateOuterClass
import gateway.v1.campaign
import gateway.v1.campaignState
import java.util.concurrent.ConcurrentHashMap

class AndroidCampaignStateRepository(
    private val getSharedDataTimestamps: GetSharedDataTimestamps
) : CampaignStateRepository {

    private val campaignStates = ConcurrentHashMap<ByteString, CampaignState>()

    override suspend fun updateState(opportunityId: ByteString, campaignState: CampaignState) {
        campaignStates[opportunityId] = campaignState
    }

    override suspend fun setShowTimestamp(opportunityId: ByteString) {
        val campaignState = getState(opportunityId)

        if (campaignState != null) {
            val timestamps = getSharedDataTimestamps()
            updateState(opportunityId, campaignState.copy(showTimestamp = timestamps))
        }
    }

    override suspend fun getState(opportunityId: ByteString): CampaignState? {
        return campaignStates[opportunityId]
    }

    override suspend fun removeState(opportunityId: ByteString) {
        campaignStates.remove(opportunityId)
    }

    override suspend fun getStates(): List<Pair<ByteString, CampaignState>> {
        return campaignStates.toList()
    }

    override suspend fun setLoadTimestamp(opportunityId: ByteString) {
        val campaignState = getState(opportunityId)

        if (campaignState != null) {
            val timestamps = getSharedDataTimestamps()
            updateState(opportunityId, campaignState.copy(loadTimestamp = timestamps))
        }
    }

    override suspend fun getCampaignState(): CampaignStateOuterClass.CampaignState {
        val states = getStates()

        return campaignState {
            states.forEach { (opportunityId, state) ->
                val campaign = campaign {
                    data = state.data
                    dataVersion = state.dataVersion
                    placementId = state.placementId
                    impressionOpportunityId = opportunityId
                    loadTimestamp = state.loadTimestamp
                    if (state.showTimestamp.hasTimestamp()) {
                        showTimestamp = state.showTimestamp
                    }
                }

                if (state.showTimestamp.hasTimestamp()) {
                    shownCampaigns += campaign
                } else {
                    loadedCampaigns += campaign
                }
            }
        }
    }
}