package com.unity3d.ads.core.data.model

sealed class ShowEvent {
    object Started : ShowEvent()
    object Clicked : ShowEvent()
    object CancelTimeout : ShowEvent()
    data class Completed(val status: ShowStatus) : ShowEvent()
    data class Error(val message: String, val errorCode: Int) : ShowEvent()
}