package com.unity3d.ads.core.data.model

import com.unity3d.ads.UnityAds

sealed class LoadResult {
    data class Success(val adObject: AdObject) : LoadResult()
    data class Failure(
        val error: UnityAds.UnityAdsLoadError,
        val message: String? = null,
        val throwable: Throwable? = null
    ) : LoadResult()

    companion object {
        const val MSG_NO_FILL = "[UnityAds] No fill"
        const val MSG_AD_OBJECT = "[UnityAds] Ad not found"
        const val MSG_COMMUNICATION_FAILURE = "[UnityAds] Internal communication failure"
        const val MSG_COMMUNICATION_FAILURE_WITH_DETAILS = "$MSG_COMMUNICATION_FAILURE: %s"
        const val MSG_COMMUNICATION_TIMEOUT = "[UnityAds] Internal communication timeout"
        const val MSG_OPPORTUNITY_ID = "[UnityAds] Object ID cannot be null"
        const val MSG_OPPORTUNITY_ID_USED = "[UnityAds] Object ID already used"
        const val MSG_PLACEMENT_NULL = "[UnityAds] Placement ID cannot be null"
        const val MSG_CREATE_REQUEST = "[UnityAds] Failed to create load request"
        const val MSG_TIMEOUT = "[UnityAds] Timeout while loading "
        const val MSG_INIT_FAILED = "[UnityAds] SDK Initialization Failed"
        const val MSG_INIT_FAILURE = "[UnityAds] SDK Initialization Failure"
    }
}