/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.configuration;

import android.os.Build;
import android.webkit.JavascriptInterface;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.SdkProperties;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class EnvironmentCheck {
    public static boolean isEnvironmentOk() {
        return EnvironmentCheck.testProGuard() && EnvironmentCheck.testCacheDirectory();
    }

    public static boolean testProGuard() {
        try {
            Class<?> webBridge = Class.forName("com.unity3d.services.core.webview.bridge.WebViewBridgeInterface");
            Method handleInvocation = webBridge.getMethod("handleInvocation", String.class);
            Method handleCallback = webBridge.getMethod("handleCallback", String.class, String.class, String.class);
            if (EnvironmentCheck.hasJavascriptInterface(handleInvocation) && EnvironmentCheck.hasJavascriptInterface(handleCallback)) {
                DeviceLog.debug("Unity Ads ProGuard check OK");
                return true;
            }
            DeviceLog.error("Unity Ads ProGuard check fail: missing @JavascriptInterface annotations in Unity Ads web bridge");
            return false;
        }
        catch (ClassNotFoundException e) {
            DeviceLog.exception("Unity Ads ProGuard check fail: Unity Ads web bridge class not found", e);
            return false;
        }
        catch (NoSuchMethodException e) {
            DeviceLog.exception("Unity Ads ProGuard check fail: Unity Ads web bridge methods not found", e);
            return false;
        }
        catch (Exception e) {
            DeviceLog.exception("Unknown exception during Unity Ads ProGuard check: " + e.getMessage(), e);
            return true;
        }
    }

    public static boolean testCacheDirectory() {
        File cacheDirectory = SdkProperties.getCacheDirectory();
        if (cacheDirectory != null) {
            DeviceLog.debug("Unity Ads cache directory check OK");
            return true;
        }
        DeviceLog.error("Unity Ads cache directory check fail: no working cache directory available");
        return false;
    }

    private static boolean hasJavascriptInterface(Method m) {
        if (Build.VERSION.SDK_INT < 17) {
            return true;
        }
        Annotation[] annotations = m.getAnnotations();
        if (annotations != null) {
            for (Annotation a : annotations) {
                if (!(a instanceof JavascriptInterface)) continue;
                return true;
            }
        }
        return false;
    }
}

