/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.ads.operation.show;

import android.app.Activity;
import android.graphics.Point;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.WindowManager;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.ads.operation.AdModule;
import com.unity3d.services.ads.operation.show.IShowModule;
import com.unity3d.services.ads.operation.show.IShowOperation;
import com.unity3d.services.ads.operation.show.ShowModuleDecoratorTimeout;
import com.unity3d.services.ads.operation.show.ShowOperation;
import com.unity3d.services.ads.operation.show.ShowOperationState;
import com.unity3d.services.core.configuration.ExperimentsReader;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.device.reader.HdrInfoReader;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.request.metrics.AdOperationError;
import com.unity3d.services.core.request.metrics.AdOperationMetric;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IWebViewBridgeInvoker;
import com.unity3d.services.core.webview.bridge.invocation.IWebViewBridgeInvocationCallback;
import com.unity3d.services.core.webview.bridge.invocation.WebViewBridgeInvocation;
import org.json.JSONException;
import org.json.JSONObject;

public class ShowModule
extends AdModule<IShowOperation, ShowOperationState>
implements IShowModule {
    private static IShowModule instance;
    public static String errorMsgPlacementIdNull;

    public static IShowModule getInstance() {
        if (instance == null) {
            instance = new ShowModuleDecoratorTimeout(new ShowModule((SDKMetricsSender)Utilities.getService(SDKMetricsSender.class)), new ExperimentsReader());
        }
        return instance;
    }

    public ShowModule(SDKMetricsSender sdkMetrics) {
        super(sdkMetrics);
    }

    @Override
    public void executeAdOperation(IWebViewBridgeInvoker webViewBridgeInvoker, final ShowOperationState state) {
        if (TextUtils.isEmpty((CharSequence)state.placementId)) {
            this.sendOnUnityAdsFailedToShow(state, errorMsgPlacementIdNull, UnityAds.UnityAdsShowError.INVALID_ARGUMENT, true);
            return;
        }
        ShowOperation showOperation = new ShowOperation(state, new WebViewBridgeInvocation(this._executorService, webViewBridgeInvoker, new IWebViewBridgeInvocationCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailure(String message, CallbackStatus callbackStatus) {
                ShowModule.this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdShowFailure(AdOperationError.callback_error, (Long)state.duration()));
                ShowModule.this.sendOnUnityAdsFailedToShow(state, message, UnityAds.UnityAdsShowError.INTERNAL_ERROR, false);
                ShowModule.this.remove(state.id);
            }

            @Override
            public void onTimeout() {
                ShowModule.this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdShowFailure(AdOperationError.callback_timeout, (Long)state.duration()));
                ShowModule.this.sendOnUnityAdsFailedToShow(state, "[UnityAds] Show Invocation Timeout", UnityAds.UnityAdsShowError.INTERNAL_ERROR, false);
                ShowModule.this.remove(state.id);
            }
        }));
        Activity activity = (Activity)state.activity.get();
        ClientProperties.setActivity(activity);
        Display defaultDisplay = ((WindowManager)activity.getSystemService("window")).getDefaultDisplay();
        JSONObject parameters = new JSONObject();
        JSONObject options = new JSONObject();
        JSONObject display = new JSONObject();
        try {
            display.put("requestedOrientation", activity.getRequestedOrientation());
            display.put("rotation", defaultDisplay.getRotation());
            if (Build.VERSION.SDK_INT >= 13) {
                Point displaySize = new Point();
                defaultDisplay.getSize(displaySize);
                display.put("width", displaySize.x);
                display.put("height", displaySize.y);
            } else {
                display.put("width", defaultDisplay.getWidth());
                display.put("height", defaultDisplay.getHeight());
            }
            options.put("display", (Object)display);
            options.put("headerBiddingOptions", (Object)state.showOptions.getData());
            parameters.put("options", (Object)options);
            parameters.put("listenerId", (Object)showOperation.getId());
            parameters.put("placementId", (Object)state.placementId);
            parameters.put("time", Device.getElapsedRealtime());
        }
        catch (JSONException e) {
            this.sendOnUnityAdsFailedToShow(state, "[UnityAds] Error creating show options", UnityAds.UnityAdsShowError.INTERNAL_ERROR, true);
            return;
        }
        catch (NullPointerException e) {
            this.sendOnUnityAdsFailedToShow(state, "[UnityAds] Error creating show options", UnityAds.UnityAdsShowError.INTERNAL_ERROR, true);
            return;
        }
        this.set(showOperation);
        showOperation.invoke(state.configuration.getWebViewBridgeTimeout(), parameters);
        HdrInfoReader.getInstance().captureHDRCapabilityMetrics(activity, new ExperimentsReader());
    }

    @Override
    public void onUnityAdsShowFailure(String id, UnityAds.UnityAdsShowError error, String message) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        ShowOperationState state = showOperation.getShowOperationState();
        this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdShowFailure(error, (Long)state.duration()));
        showOperation.onUnityAdsShowFailure(state.placementId, error, message);
        this.remove(id);
    }

    @Override
    public void onUnityAdsShowConsent(String id) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
    }

    @Override
    public void onUnityAdsShowStart(String id) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        showOperation.onUnityAdsShowStart(showOperation.getShowOperationState().placementId);
    }

    @Override
    public void onUnityAdsShowClick(String id) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        showOperation.onUnityAdsShowClick(showOperation.getShowOperationState().placementId);
    }

    @Override
    public void onUnityAdsShowComplete(String id, UnityAds.UnityAdsShowCompletionState state) {
        IShowOperation showOperation = (IShowOperation)this.get(id);
        if (showOperation == null || showOperation.getShowOperationState() == null) {
            return;
        }
        ShowOperationState showState = showOperation.getShowOperationState();
        this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdShowSuccess(showState.duration()));
        showOperation.onUnityAdsShowComplete(showState.placementId, state);
        this.remove(id);
    }

    private void sendOnUnityAdsFailedToShow(final ShowOperationState state, final String message, final UnityAds.UnityAdsShowError error, boolean sendMetrics2) {
        if (state == null || state.listener == null) {
            return;
        }
        if (sendMetrics2) {
            this.getMetricSender().sendMetricWithInitState(AdOperationMetric.newAdShowFailure(error, (Long)state.duration()));
        }
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                state.onUnityAdsShowFailure(error, message);
            }
        });
    }

    static {
        errorMsgPlacementIdNull = "[UnityAds] Placement ID cannot be null";
    }
}

