/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.UnityAdsSDK;
import com.unity3d.services.core.configuration.EnvironmentCheck;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.properties.Session;
import com.unity3d.services.core.request.metrics.InitMetric;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0002J.\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001c\u001a\u00020\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007R*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u00048FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\n\u0010\u0007R\u001c\u0010\f\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\f\u0010\u0007R\u001a\u0010\u000e\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/unity3d/services/UnityServices;", "", "()V", "debugMode", "", "getDebugMode$annotations", "getDebugMode", "()Z", "setDebugMode", "(Z)V", "isInitialized", "isInitialized$annotations", "isSupported", "isSupported$annotations", "version", "", "getVersion$annotations", "getVersion", "()Ljava/lang/String;", "createExpectedParametersString", "fieldName", "current", "received", "initialize", "", "context", "Landroid/content/Context;", "gameId", "testMode", "initializationListener", "Lcom/unity3d/ads/IUnityAdsInitializationListener;", "UnityServicesError", "unity-ads_release"})
public final class UnityServices {
    @NotNull
    public static final UnityServices INSTANCE = new UnityServices();
    private static final boolean isSupported = true;

    private UnityServices() {
    }

    /*
     * Enabled aggressive block sorting
     */
    @JvmStatic
    public static final void initialize(@Nullable Context context, @Nullable String gameId, boolean testMode, @Nullable IUnityAdsInitializationListener initializationListener) {
        block19: {
            String string;
            StringBuilder stringBuilder2;
            block20: {
                block18: {
                    DeviceLog.entered();
                    Object object = gameId;
                    if (object == null || (object = StringsKt.toIntOrNull((String)object)) == null) break block18;
                    ((Integer)object).intValue();
                    if (SdkProperties.getCurrentInitializationState() == SdkProperties.InitializationState.NOT_INITIALIZED) break block19;
                    break block20;
                }
                UnityServices $this$initialize_u24lambda_u240 = INSTANCE;
                boolean stringBuilder2 = false;
                IUnityAdsInitializationListener iUnityAdsInitializationListener = initializationListener;
                if (iUnityAdsInitializationListener == null) return;
                iUnityAdsInitializationListener.onInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "gameId \"" + gameId + "\" should be a number.");
                return;
            }
            String previousGameId = ClientProperties.getGameId();
            boolean previousTestMode = SdkProperties.isTestMode();
            StringBuilder $this$initialize_u24lambda_u241 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            if (previousGameId != null && !Intrinsics.areEqual((Object)previousGameId, (Object)gameId)) {
                StringBuilder stringBuilder3 = $this$initialize_u24lambda_u241.append(INSTANCE.createExpectedParametersString("Game ID", previousGameId, gameId));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            }
            if (previousTestMode != testMode) {
                StringBuilder stringBuilder4 = $this$initialize_u24lambda_u241.append(INSTANCE.createExpectedParametersString("Test Mode", previousTestMode, testMode));
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            }
            String string2 = stringBuilder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            String differingParameters = string2;
            if (((CharSequence)differingParameters).length() > 0) {
                InitializeEventsMetricSender.getInstance().sendMetric(InitMetric.newInitDiffParams());
                string = "different parameters: \n" + differingParameters;
            } else {
                InitializeEventsMetricSender.getInstance().sendMetric(InitMetric.newInitSameParams());
                string = "the same Game ID: " + gameId + " and Test Mode: " + testMode + " values.";
            }
            String params = string;
            DeviceLog.warning("Unity Ads SDK initialize has already been called with " + params + " Responding with first initialization result.");
        }
        SdkProperties.addInitializationListener(initializationListener);
        SdkProperties.InitializationState initializationState = SdkProperties.getCurrentInitializationState();
        switch (initializationState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[initializationState.ordinal()]) {
            case 1: {
                SdkProperties.notifyInitializationComplete();
                return;
            }
            case 2: {
                SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to previous failed reason");
                return;
            }
            case 3: {
                return;
            }
        }
        SdkProperties.setInitializeState(SdkProperties.InitializationState.INITIALIZING);
        ClientProperties.setGameId(gameId);
        SdkProperties.setTestMode(testMode);
        if (!isSupported) {
            DeviceLog.error("Error while initializing Unity Services: device is not supported");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to device is not supported");
            return;
        }
        SdkProperties.setInitializationTime(Device.getElapsedRealtime());
        SdkProperties.setInitializationTimeSinceEpoch(System.currentTimeMillis());
        if (((CharSequence)gameId).length() == 0) {
            DeviceLog.error("Error while initializing Unity Services: empty game ID, halting Unity Ads init");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to empty game ID");
            return;
        }
        if (context == null) {
            DeviceLog.error("Error while initializing Unity Services: null context, halting Unity Ads init");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to null context");
            return;
        }
        if (context instanceof Application) {
            ClientProperties.setApplication((Application)context);
        } else {
            if (!(context instanceof Activity)) {
                DeviceLog.error("Error while initializing Unity Services: invalid context, halting Unity Ads init");
                SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to invalid context");
                return;
            }
            if (((Activity)context).getApplication() == null) {
                DeviceLog.error("Error while initializing Unity Services: cannot retrieve application from context, halting Unity Ads init");
                SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to inability to retrieve application from context");
                return;
            }
            ClientProperties.setApplication(((Activity)context).getApplication());
        }
        String mode = testMode ? "test mode" : "production mode";
        DeviceLog.info("Initializing Unity Services " + SdkProperties.getVersionName() + " (" + SdkProperties.getVersionCode() + ") with game id " + gameId + " in " + mode + ", session " + Session.Default.getId());
        SdkProperties.setDebugMode(SdkProperties.getDebugMode());
        if (context.getApplicationContext() == null) {
            DeviceLog.error("Error while initializing Unity Services: cannot retrieve application context, halting Unity Ads init");
            SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INVALID_ARGUMENT, "Unity Ads SDK failed to initialize due to inability to retrieve application context");
            return;
        }
        ClientProperties.setApplicationContext(context.getApplicationContext());
        if (EnvironmentCheck.isEnvironmentOk()) {
            DeviceLog.info("Unity Services environment check OK");
            UnityAdsSDK.INSTANCE.initialize();
            return;
        }
        DeviceLog.error("Error during Unity Services environment check, halting Unity Services init");
        SdkProperties.notifyInitializationFailed(UnityAds.UnityAdsInitializationError.INTERNAL_ERROR, "Unity Ads SDK failed to initialize due to environment check failed");
    }

    public static final boolean isSupported() {
        return isSupported;
    }

    @JvmStatic
    public static /* synthetic */ void isSupported$annotations() {
    }

    public static final boolean isInitialized() {
        return SdkProperties.isInitialized();
    }

    @JvmStatic
    public static /* synthetic */ void isInitialized$annotations() {
    }

    @NotNull
    public static final String getVersion() {
        String string = SdkProperties.getVersionName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionName()");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getVersion$annotations() {
    }

    public static final boolean getDebugMode() {
        return SdkProperties.getDebugMode();
    }

    public static final void setDebugMode(boolean debugMode) {
        SdkProperties.setDebugMode(debugMode);
    }

    @JvmStatic
    public static /* synthetic */ void getDebugMode$annotations() {
    }

    private final String createExpectedParametersString(String fieldName, Object current, Object received) {
        return "- " + fieldName + " Current: " + current + " | Received: " + received;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/unity3d/services/UnityServices$UnityServicesError;", "", "(Ljava/lang/String;I)V", "INVALID_ARGUMENT", "INIT_SANITY_CHECK_FAIL", "unity-ads_release"})
    public static final class UnityServicesError
    extends Enum<UnityServicesError> {
        public static final /* enum */ UnityServicesError INVALID_ARGUMENT = new UnityServicesError();
        public static final /* enum */ UnityServicesError INIT_SANITY_CHECK_FAIL = new UnityServicesError();
        private static final /* synthetic */ UnityServicesError[] $VALUES;

        public static UnityServicesError[] values() {
            return (UnityServicesError[])$VALUES.clone();
        }

        public static UnityServicesError valueOf(String value) {
            return Enum.valueOf(UnityServicesError.class, value);
        }

        static {
            $VALUES = unityServicesErrorArray = new UnityServicesError[]{UnityServicesError.INVALID_ARGUMENT, UnityServicesError.INIT_SANITY_CHECK_FAIL};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SdkProperties.InitializationState.values().length];
            try {
                nArray[SdkProperties.InitializationState.INITIALIZED_SUCCESSFULLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SdkProperties.InitializationState.INITIALIZED_FAILED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SdkProperties.InitializationState.INITIALIZING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

