/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.device;

import android.content.Context;
import com.unity3d.services.core.device.InMemoryStorage;
import com.unity3d.services.core.device.Storage;
import com.unity3d.services.core.properties.SdkProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageManager {
    private static final Map<StorageType, String> _storageFileMap = Collections.synchronizedMap(new HashMap());
    private static final List<Storage> _storages = Collections.synchronizedList(new ArrayList());

    public static boolean init(Context context) {
        if (context == null) {
            return false;
        }
        File cacheDir = context.getFilesDir();
        if (cacheDir == null) {
            return false;
        }
        StorageManager.addStorageLocation(StorageType.PUBLIC, cacheDir + "/" + SdkProperties.getLocalStorageFilePrefix() + "public-data.json");
        if (!StorageManager.setupStorage(StorageType.PUBLIC)) {
            return false;
        }
        StorageManager.addStorageLocation(StorageType.PRIVATE, cacheDir + "/" + SdkProperties.getLocalStorageFilePrefix() + "private-data.json");
        if (!StorageManager.setupStorage(StorageType.PRIVATE)) {
            return false;
        }
        return StorageManager.setupStorage(StorageType.MEMORY);
    }

    public static void initStorage(StorageType type) {
        if (StorageManager.hasStorage(type)) {
            Storage s = StorageManager.getStorage(type);
            if (s != null) {
                s.initStorage();
            }
        } else if (_storageFileMap.containsKey((Object)type)) {
            Storage s = new Storage(_storageFileMap.get((Object)type), type);
            s.initStorage();
            _storages.add(s);
        } else if (type.equals((Object)StorageType.MEMORY)) {
            InMemoryStorage s = new InMemoryStorage();
            s.initStorage();
            _storages.add(s);
        }
    }

    private static boolean setupStorage(StorageType type) {
        if (!StorageManager.hasStorage(type)) {
            StorageManager.initStorage(type);
            Storage s = StorageManager.getStorage(type);
            if (s != null && !s.storageFileExists()) {
                s.writeStorage();
            }
            if (s == null) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Storage getStorage(StorageType type) {
        if (_storages != null) {
            List<Storage> list = _storages;
            synchronized (list) {
                for (Storage s : _storages) {
                    if (!s.getType().equals((Object)type)) continue;
                    return s;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasStorage(StorageType type) {
        if (_storages != null) {
            List<Storage> list = _storages;
            synchronized (list) {
                for (Storage s : _storages) {
                    if (!s.getType().equals((Object)type)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static synchronized void addStorageLocation(StorageType type, String filename) {
        if (!_storageFileMap.containsKey((Object)type)) {
            _storageFileMap.put(type, filename);
        }
    }

    public static synchronized void removeStorage(StorageType type) {
        if (StorageManager.getStorage(type) != null) {
            _storages.remove(StorageManager.getStorage(type));
        }
        if (_storageFileMap != null) {
            _storageFileMap.remove((Object)type);
        }
    }

    public static enum StorageType {
        PRIVATE,
        PUBLIC,
        MEMORY;

    }
}

