/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.banners.view;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.RelativeLayout;
import com.unity3d.services.ads.webplayer.WebPlayerView;
import com.unity3d.services.banners.UnityBannerSize;
import com.unity3d.services.banners.bridge.BannerBridge;
import com.unity3d.services.core.misc.Utilities;
import com.unity3d.services.core.misc.ViewUtilities;
import org.json.JSONObject;

public class BannerWebPlayerContainer
extends RelativeLayout {
    private WebPlayerView _webPlayerView;
    private int _lastVisibility = -1;
    private UnityBannerSize _size;
    private String _bannerAdId;
    private JSONObject _webSettings;
    private JSONObject _webPlayerSettings;
    private JSONObject _webPlayerEventSettings;
    private Runnable _unsubscribeLayoutChange = null;

    public BannerWebPlayerContainer(Context context, String bannerAdId, JSONObject webSettings, JSONObject webPlayerSettings, JSONObject webPlayerEventSettings, UnityBannerSize size) {
        super(context);
        this._size = size;
        this._bannerAdId = bannerAdId;
        this._webSettings = webSettings;
        this._webPlayerSettings = webPlayerSettings;
        this._webPlayerEventSettings = webPlayerEventSettings;
        this._webPlayerView = new WebPlayerView(context, bannerAdId, this._webSettings, this._webPlayerSettings);
        this._webPlayerView.setEventSettings(this._webPlayerEventSettings);
        this.subscribeOnLayoutChange();
        this.addView((View)this._webPlayerView);
        this.setupLayoutParams();
    }

    private void subscribeOnLayoutChange() {
        if (this._unsubscribeLayoutChange != null) {
            this._unsubscribeLayoutChange.run();
        }
        if (Build.VERSION.SDK_INT >= 11) {
            final View.OnLayoutChangeListener onLayoutChangeListener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    BannerWebPlayerContainer.this.onLayoutChange(v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom);
                }
            };
            this.addOnLayoutChangeListener(onLayoutChangeListener);
            this._unsubscribeLayoutChange = new Runnable(){

                @Override
                public void run() {
                    BannerWebPlayerContainer.this.removeOnLayoutChangeListener(onLayoutChangeListener);
                }
            };
        }
    }

    private void setupLayoutParams() {
        int width = Math.round(ViewUtilities.pxFromDp(this.getContext(), this._size.getWidth()));
        int height = Math.round(ViewUtilities.pxFromDp(this.getContext(), this._size.getHeight()));
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(width, height);
        this.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        ViewGroup.LayoutParams webviewLayoutParams = this._webPlayerView.getLayoutParams();
        webviewLayoutParams.height = -1;
        webviewLayoutParams.width = -1;
        this._webPlayerView.setLayoutParams(webviewLayoutParams);
    }

    public void setWebPlayerEventSettings(JSONObject webPlayerEventSettings) {
        this._webPlayerEventSettings = webPlayerEventSettings;
    }

    public void setWebPlayerSettings(JSONObject webSettings, JSONObject webPlayerSettings) {
        this._webSettings = webSettings;
        this._webPlayerSettings = webPlayerSettings;
    }

    public void destroy() {
        if (this._unsubscribeLayoutChange != null) {
            this._unsubscribeLayoutChange.run();
        }
        final BannerWebPlayerContainer self = this;
        Utilities.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                self.removeAllViews();
                ViewParent parent = self.getParent();
                if (parent != null && parent instanceof ViewGroup) {
                    ((ViewGroup)parent).removeView((View)self);
                }
                if (self._webPlayerView != null) {
                    self._webPlayerView.destroy();
                }
                self._webPlayerView = null;
            }
        });
    }

    public WebPlayerView getWebPlayer() {
        return this._webPlayerView;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        BannerBridge.didAttach(this._bannerAdId);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        BannerBridge.didDetach(this._bannerAdId);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (oldw != 0 || oldh != 0) {
            int left = this.getLeft();
            int right = this.getRight();
            float alpha = 1.0f;
            if (Build.VERSION.SDK_INT >= 11) {
                alpha = this.getAlpha();
            }
            BannerBridge.resize(this._bannerAdId, left, right, w, h, alpha);
            Rect rect = new Rect();
            this.getHitRect(rect);
            if (((View)this.getParent()).getLocalVisibleRect(rect)) {
                this.onVisibilityChanged((View)this, 8);
            }
        }
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        if (changedView == this) {
            if (this._lastVisibility == -1) {
                this._lastVisibility = visibility;
            } else {
                if (visibility != 0 && this._lastVisibility == 0) {
                    BannerBridge.visibilityChanged(this._bannerAdId, visibility);
                }
                this._lastVisibility = visibility;
            }
        }
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        float alpha = 1.0f;
        if (Build.VERSION.SDK_INT >= 11) {
            alpha = this.getAlpha();
        }
        BannerBridge.resize(this._bannerAdId, left, top, right, bottom, alpha);
        if (this.getParent() != null) {
            Rect rect = new Rect();
            this.getHitRect(rect);
            if (this.getParent() instanceof View && !((View)this.getParent()).getLocalVisibleRect(rect)) {
                this.onVisibilityChanged((View)this, 8);
            }
        }
    }

    public void setAlpha(float alpha) {
        super.setAlpha(alpha);
        this.onLayoutChange((View)this, this.getLeft(), this.getTop(), this.getRight(), this.getBottom(), this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
    }
}

