package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge

class ProductBridge(private val productInternalInstance: Any?): GenericBridge(
    emptyMap()
) {

    override fun getClassName(): String {
        return "com.android.billingclient.api.QueryProductDetailsParams\$Product"
    }

    fun getInternalClass(): Any? {
        return productInternalInstance
    }

    companion object {
        fun getClassForParams(): Class<*> {
            return Class.forName("com.android.billingclient.api.QueryProductDetailsParams\$Product")
        }

        const val NEW_BUILDER_METHOD = "newBuilder"

        fun newBuilder(): ProductBuilderBridge {
            val billingClientBuilderInternalInstance = callNonVoidStaticMethod(NEW_BUILDER_METHOD)
            return ProductBuilderBridge(billingClientBuilderInternalInstance)
        }

        private fun callNonVoidStaticMethod(methodName: String): Any {
            val method = getClassForParams().getMethod(methodName)
            return method.invoke(null) ?: throw IllegalStateException("Static method $methodName returned null")
        }

    }
}