package com.unity3d.ads.core.domain.scar

import com.unity3d.ads.TokenConfiguration
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.extensions.toProtoAdFormat
import gatewayprotocol.v1.AdFormatOuterClass.AdFormat

class CommonScarEligibleEffectiveUseCase(
    val sessionRepository: SessionRepository
): ScarEligibleEffectiveUseCase {
    override fun invoke(tokenConfiguration: TokenConfiguration?): List<AdFormat> {
        return if (tokenConfiguration == null) {
            sessionRepository.scarEligibleFormats
        } else {
            tokenConfiguration.adFormat.toProtoAdFormat().takeIf {
                sessionRepository.scarEligibleFormats.contains(it)
            }?.let {
                listOf(it)
            } ?: emptyList()
        }
    }
}