package com.unity3d.ads.core.configuration

import com.unity3d.services.core.misc.JsonStorage

abstract class MetadataReader<T>(val jsonStorage: JsonStorage, val key: String) {

    inline fun <reified T> read(defaultValue: T? = null): T? {
        return jsonStorage.get(key)?.let {
            when (it) {
                is T -> it
                else -> defaultValue
            }
        } ?: defaultValue
    }

    inline fun <reified T> readAndDelete(defaultValue: T? = null): T? {
        return read(defaultValue).also {
            jsonStorage.get(key)?.let {
                jsonStorage.delete(key)
            }
        }
    }

}