/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.webview.bridge;

import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.webview.bridge.CallbackStatus;
import com.unity3d.services.core.webview.bridge.IInvocationCallbackInvoker;
import com.unity3d.services.core.webview.bridge.IWebViewBridge;
import com.unity3d.services.core.webview.bridge.SharedInstances;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Invocation {
    private static AtomicInteger _idCount = new AtomicInteger(0);
    private static Map<Integer, Invocation> _invocationSets;
    private ArrayList<ArrayList<Object>> _invocations;
    private ArrayList<ArrayList<Object>> _responses;
    private int _invocationId;
    private IInvocationCallbackInvoker _invocationCallbackInvoker;
    private final IWebViewBridge _webViewBridge;

    public Invocation() {
        this(SharedInstances.INSTANCE.getWebViewAppInvocationCallbackInvoker(), SharedInstances.INSTANCE.getWebViewBridge());
    }

    public Invocation(IWebViewBridge webViewBridge2) {
        this(SharedInstances.INSTANCE.getWebViewAppInvocationCallbackInvoker(), webViewBridge2);
    }

    public Invocation(IInvocationCallbackInvoker invocationHandler, IWebViewBridge webViewBridge2) {
        this._invocationCallbackInvoker = invocationHandler;
        this._webViewBridge = webViewBridge2;
        this._invocationId = _idCount.getAndIncrement();
        if (_invocationSets == null) {
            _invocationSets = new HashMap<Integer, Invocation>();
        }
        _invocationSets.put(this._invocationId, this);
    }

    public void addInvocation(String className, String methodName, Object[] parameters, WebViewCallback callback2) {
        if (this._invocations == null) {
            this._invocations = new ArrayList();
        }
        ArrayList<Object> invocation = new ArrayList<Object>();
        invocation.add(className);
        invocation.add(methodName);
        invocation.add(parameters);
        invocation.add(callback2);
        this._invocations.add(invocation);
    }

    public boolean nextInvocation() {
        if (this._invocations != null && this._invocations.size() > 0) {
            ArrayList<Object> invocation = this._invocations.remove(0);
            String className = (String)invocation.get(0);
            String methodName = (String)invocation.get(1);
            Object[] params = (Object[])invocation.get(2);
            WebViewCallback callback2 = (WebViewCallback)invocation.get(3);
            try {
                this._webViewBridge.handleInvocation(className, methodName, params, callback2);
            }
            catch (Exception e) {
                DeviceLog.exception(String.format("Error handling invocation %s.%s(%s)", className, methodName, Arrays.toString(params)), e);
            }
            return true;
        }
        return false;
    }

    public void setInvocationResponse(CallbackStatus status, Enum error2, Object ... params) {
        if (this._responses == null) {
            this._responses = new ArrayList();
        }
        ArrayList<Object> response = new ArrayList<Object>();
        response.add((Object)status);
        response.add(error2);
        response.add(params);
        this._responses.add(response);
    }

    public void sendInvocationCallback() {
        _invocationSets.remove(this.getId());
        this._invocationCallbackInvoker.invokeCallback(this);
    }

    public int getId() {
        return this._invocationId;
    }

    public ArrayList<ArrayList<Object>> getResponses() {
        return this._responses;
    }

    public static synchronized Invocation getInvocationById(int id) {
        if (_invocationSets != null && _invocationSets.containsKey(id)) {
            return _invocationSets.get(id);
        }
        return null;
    }
}

