package com.unity3d.services.store.core

import com.unity3d.services.store.StoreWebViewEventSender
import com.unity3d.services.store.WebViewStoreEventListener
import com.unity3d.services.store.gpbl.listeners.StoreEventListener



class StoreEventListenerFactory (
    private val storeWebViewEventSender: StoreWebViewEventSender
) {
    @JvmOverloads
    operator fun invoke(operationId: Int = -1, isLifecycleListener: Boolean = false): StoreEventListener {
        return WebViewStoreEventListener(operationId, storeWebViewEventSender, isLifecycleListener)
    }
}