package com.unity3d.ads.core.log

import android.util.Log

enum class LogLevel(internal val level: Int) {
    DISABLED(0), ERROR(1), INFO(2), DEBUG(3), TRACE(4);

    fun toAndroidLogLevel(): Int {
        return when (this) {
            DISABLED -> Int.MAX_VALUE
            ERROR -> Log.ERROR
            INFO -> Log.INFO
            DEBUG -> Log.DEBUG
            TRACE -> Log.VERBOSE
        }
    }
}