package com.unity3d.ads.core.domain.om

import android.webkit.WebView
import com.iab.omid.library.unity3d.adsession.CreativeType
import com.iab.omid.library.unity3d.adsession.ImpressionType
import com.iab.omid.library.unity3d.adsession.Owner
import com.unity3d.ads.adplayer.AndroidEmbeddableWebViewAdPlayer
import com.unity3d.ads.adplayer.AndroidFullscreenWebViewAdPlayer
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_CREATIVE_TYPE
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_CUSTOM_REFERENCE_DATA
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_IMPRESSION_OWNER
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_ISOLATE_VERIFICATION_SCRIPTS
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_MEDIA_EVENTS_OWNER
import com.unity3d.ads.core.domain.om.OmInteraction.Companion.OMID_VIDEO_EVENTS_OWNER
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.OmidOptions
import org.json.JSONObject

// Mappers are based on iOS OMSDK implementation which use 1 index enum instead of 0
abstract class AndroidOmInteraction : OmInteraction {
    override fun getWebview(adObject: AdObject): WebView? {
        return when (val adPLayer = adObject.adPlayer) {
            is AndroidFullscreenWebViewAdPlayer -> adPLayer.webViewContainer.webView
            is AndroidEmbeddableWebViewAdPlayer -> adPLayer.webViewContainer.webView
            else -> null
        }
    }

    override fun getOMidOptions(options: JSONObject): OmidOptions {
        return OmidOptions(
            isolateVerificationScripts = options.optBoolean(OMID_ISOLATE_VERIFICATION_SCRIPTS),
            impressionOwner = getImpressionsOwner(options),
            videoEventsOwner = getVideoEventsOwner(options),
            customReferenceData = options.optString(OMID_CUSTOM_REFERENCE_DATA),
            impressionType = getImpressionType(options),
            creativeType = getCreativeType(options),
            mediaEventsOwner = getMediaEventsOwner(options),
        )
    }

    private fun getImpressionType(options: JSONObject): ImpressionType {
        return when (options.optInt(OmInteraction.OMID_IMPRESSION_TYPE)) {
            1 -> ImpressionType.DEFINED_BY_JAVASCRIPT
            2 -> ImpressionType.UNSPECIFIED
            3 -> ImpressionType.LOADED
            4 -> ImpressionType.BEGIN_TO_RENDER
            5 -> ImpressionType.ONE_PIXEL
            6 -> ImpressionType.VIEWABLE
            7 -> ImpressionType.AUDIBLE
            8 -> ImpressionType.OTHER
            else -> throw IllegalArgumentException("Invalid impressionType")
        }
    }

    private fun getCreativeType(options: JSONObject): CreativeType {
        return when (options.optInt(OMID_CREATIVE_TYPE)) {
            1 -> CreativeType.DEFINED_BY_JAVASCRIPT
            2 -> CreativeType.HTML_DISPLAY
            3 -> CreativeType.NATIVE_DISPLAY
            4 -> CreativeType.VIDEO
            5 -> CreativeType.AUDIO
            else -> throw IllegalArgumentException("Invalid creativeType")
        }
    }

    private fun getVideoEventsOwner(options: JSONObject): Owner {
        return try {
            when (options.optInt(OMID_VIDEO_EVENTS_OWNER)) {
                1 -> Owner.JAVASCRIPT
                2 -> Owner.NATIVE
                3 -> Owner.NONE
                else -> throw IllegalArgumentException("Invalid videoEventsOwner")
            }
        } catch (t: IllegalArgumentException) {
            Owner.NONE
        }
    }

    private fun getMediaEventsOwner(options: JSONObject): Owner {
        return try {
            when (options.optInt(OMID_MEDIA_EVENTS_OWNER)) {
                1 -> Owner.JAVASCRIPT
                2 -> Owner.NATIVE
                3 -> Owner.NONE
                else -> throw IllegalArgumentException("Invalid mediaEventsOwner")
            }
        } catch (t: IllegalArgumentException) {
            Owner.NONE
        }
    }

    private fun getImpressionsOwner(options: JSONObject): Owner {
        return try {
            when (options.optInt(OMID_IMPRESSION_OWNER)) {
                1 -> Owner.JAVASCRIPT
                2 -> Owner.NATIVE
                3 -> Owner.NONE
                else -> throw IllegalArgumentException("Invalid impressionOwner")
            }
        } catch (t: IllegalArgumentException) {
            Owner.NONE
        }
    }
}