package com.unity3d.ads.core.domain.events

import com.unity3d.ads.gatewayclient.RequestPolicy
import gatewayprotocol.v1.UniversalRequestOuterClass.UniversalRequest

class CommonUniversalRequestTtlValidator : UniversalRequestTtlValidator {
    override fun invoke(universalRequest: UniversalRequest, requestPolicy: RequestPolicy): Boolean {
        val timeDiffSec = System.currentTimeMillis() - universalRequest.sharedData.timestamps.timestamp.seconds * 1000
        return (timeDiffSec < requestPolicy.maxDuration)
    }
}