package com.unity3d.ads.core.domain

import com.unity3d.services.core.misc.Utilities.wrapCustomerListener
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch

class CommonSafeCallbackInvoke(
    private val mainDispatcher: CoroutineDispatcher
) : SafeCallbackInvoke {
    override fun invoke(block: () -> Unit) {
        CoroutineScope(mainDispatcher).launch {
            wrapCustomerListener {
                block()
            }
        }
    }
}