package com.unity3d.ads.core.domain

import com.unity3d.ads.adplayer.*
import com.unity3d.ads.core.log.Logger
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers

internal class CommonGetWebViewBridgeUseCase(
    private val dispatcher: CoroutineDispatcher = Dispatchers.Default,
    private val sendDiagnosticEvent: SendDiagnosticEvent,
    private val logger: Logger,
) : GetWebViewBridgeUseCase {
    override fun invoke(webViewContainer: AndroidWebViewContainer, adPlayerScope: CoroutineScope): WebViewBridge {
        return CommonWebViewBridge(
            webViewContainer = webViewContainer,
            dispatcher = dispatcher,
            adPlayerScope = adPlayerScope,
            sendDiagnosticEvent = sendDiagnosticEvent,
            logger = logger,
        )
    }
}