/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.common;

import android.app.Activity;
import android.content.Context;
import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.IAdsErrorHandler;
import com.unity3d.scar.adapter.common.IScarAdapter;
import com.unity3d.scar.adapter.common.Utils;
import com.unity3d.scar.adapter.common.WebViewAdsError;
import com.unity3d.scar.adapter.common.scarads.IScarFullScreenAd;
import com.unity3d.scar.adapter.common.scarads.UnityAdFormat;
import com.unity3d.scar.adapter.common.signals.ISignalCollectionListener;
import com.unity3d.scar.adapter.common.signals.ISignalsCollector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ScarAdapterBase
implements IScarAdapter {
    protected ISignalsCollector _signalCollector;
    protected Map<String, IScarFullScreenAd> _loadedAds = new ConcurrentHashMap<String, IScarFullScreenAd>();
    protected IScarFullScreenAd _currentAdReference;
    protected IAdsErrorHandler<WebViewAdsError> _adsErrorHandler;

    public ScarAdapterBase(IAdsErrorHandler<WebViewAdsError> adsErrorHandler) {
        this._adsErrorHandler = adsErrorHandler;
    }

    @Override
    public void getSCARBiddingSignals(Context context, List<UnityAdFormat> adFormats, ISignalCollectionListener signalCompletionListener) {
        this._signalCollector.getSCARBiddingSignals(context, adFormats, signalCompletionListener);
    }

    @Override
    public void getSCARBiddingSignals(Context context, boolean isBannerEnabled, ISignalCollectionListener signalCompletionListener) {
        this._signalCollector.getSCARBiddingSignals(context, isBannerEnabled, signalCompletionListener);
    }

    @Override
    public void getSCARSignal(Context context, String placementId, UnityAdFormat adFormat, ISignalCollectionListener signalCompletionListener) {
        this._signalCollector.getSCARSignal(context, placementId, adFormat, signalCompletionListener);
    }

    @Override
    public void show(final Activity activity, String queryId, String placementId) {
        IScarFullScreenAd scarAd = this._loadedAds.get(placementId);
        if (scarAd == null) {
            this._adsErrorHandler.handleError(GMAAdsError.NoAdsError(placementId, queryId, "Could not find ad for placement '" + placementId + "'."));
        } else {
            this._currentAdReference = scarAd;
            Utils.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ScarAdapterBase.this._currentAdReference.show(activity);
                }
            });
        }
    }
}

