/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.ads.core.domain;

import com.unity3d.ads.core.domain.CheckForGameIdAndTestModeChanges;
import com.unity3d.ads.core.domain.GetGameId;
import com.unity3d.ads.core.domain.SendDiagnosticEvent;
import com.unity3d.services.core.configuration.InitializeEventsMetricSender;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.request.metrics.Metric;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J,\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010\u0010\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/unity3d/ads/core/domain/CommonCheckForGameIdAndTestModeChanges;", "Lcom/unity3d/ads/core/domain/CheckForGameIdAndTestModeChanges;", "getGameId", "Lcom/unity3d/ads/core/domain/GetGameId;", "sendDiagnosticEvent", "Lcom/unity3d/ads/core/domain/SendDiagnosticEvent;", "(Lcom/unity3d/ads/core/domain/GetGameId;Lcom/unity3d/ads/core/domain/SendDiagnosticEvent;)V", "invoke", "", "legacy", "", "sendDiagnostic", "event", "", "tags", "", "isLegacy", "unity-ads_defaultRelease"})
public final class CommonCheckForGameIdAndTestModeChanges
implements CheckForGameIdAndTestModeChanges {
    @NotNull
    private final GetGameId getGameId;
    @NotNull
    private final SendDiagnosticEvent sendDiagnosticEvent;

    public CommonCheckForGameIdAndTestModeChanges(@NotNull GetGameId getGameId, @NotNull SendDiagnosticEvent sendDiagnosticEvent2) {
        Intrinsics.checkNotNullParameter((Object)getGameId, (String)"getGameId");
        Intrinsics.checkNotNullParameter((Object)sendDiagnosticEvent2, (String)"sendDiagnosticEvent");
        this.getGameId = getGameId;
        this.sendDiagnosticEvent = sendDiagnosticEvent2;
    }

    @Override
    public void invoke(boolean legacy) {
        String string;
        String gameId;
        String string2 = this.getGameId.invoke();
        if (string2 == null) {
            string2 = gameId = "null";
        }
        if ((string = ClientProperties.getPreviousGameId()) == null) {
            string = "null";
        }
        String previousGameId = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"previous_game_id", (Object)previousGameId), TuplesKt.to((Object)"game_id", (Object)gameId)};
        Map gameIdMap = MapsKt.mapOf((Pair[])pairArray);
        if (!Intrinsics.areEqual((Object)previousGameId, (Object)"null")) {
            if (!Intrinsics.areEqual((Object)gameId, (Object)previousGameId)) {
                this.sendDiagnostic("native_initialize_game_id_changed", gameIdMap, legacy);
            } else {
                this.sendDiagnostic("native_initialize_game_id_same", gameIdMap, legacy);
            }
            boolean testMode = SdkProperties.isTestMode();
            boolean previousTestMode = SdkProperties.getPreviousTestMode();
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"previous_test_mode", (Object)String.valueOf(previousTestMode)), TuplesKt.to((Object)"test_mode", (Object)String.valueOf(testMode))};
            Map testModeMap = MapsKt.mapOf((Pair[])pairArray2);
            if (testMode != previousTestMode) {
                this.sendDiagnostic("native_initialize_test_mode_changed", testModeMap, legacy);
            } else {
                this.sendDiagnostic("native_initialize_test_mode_same", testModeMap, legacy);
            }
        }
    }

    private final void sendDiagnostic(String event, Map<String, String> tags, boolean isLegacy) {
        if (isLegacy) {
            InitializeEventsMetricSender.getInstance().sendMetric(new Metric(event, tags, null, 4, null));
        } else {
            SendDiagnosticEvent.DefaultImpls.invoke$default(this.sendDiagnosticEvent, event, null, tags, null, null, null, 58, null);
        }
    }
}

