package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.store.gpbl.bridges.billingclient.IBillingClientBuilderBridge
import com.unity3d.services.store.gpbl.bridges.billingclient.common.BillingClientBridgeCommon
import com.unity3d.services.store.gpbl.bridges.billingclient.common.BillingClientBuilderBridgeCommon

class BillingClientBuilderBridge(billingClientBuilderInternalInstance: Any?) : BillingClientBuilderBridgeCommon(
    billingClientBuilderInternalInstance, hashMapOf(
        ENABLE_PENDING_PURCHASES_METHOD to arrayOf(PendingPurchasesParamsBridge.getClassForParams()),
    )
) {
    override fun enablePendingPurchases(): IBillingClientBuilderBridge {
        _billingClientBuilderInternalInstance = callNonVoidMethod(
            ENABLE_PENDING_PURCHASES_METHOD,
            _billingClientBuilderInternalInstance,
            PendingPurchasesParamsBridge.newBuilder().enableOneTimeProducts().build().getInternalClass()
        )
        return this
    }

    @Throws(ClassNotFoundException::class)
    override fun build(): BillingClientBridgeCommon {
        val billingClient =
            callNonVoidMethod<Any>(buildMethodName, _billingClientBuilderInternalInstance)
        return BillingClientBridge(billingClient)
    }

    companion object {
        const val ENABLE_PENDING_PURCHASES_METHOD = "enablePendingPurchases"
    }
}