package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.extensions.getSHA256Hash
import okio.ByteString

class AndroidGetIsAdActivity(
    private val sessionRepository: SessionRepository
) {
    private val activities by lazy {
        sessionRepository.nativeConfiguration.observableAndroidActivitiesList.map { ByteString.of(*it.toByteArray()) }
    }

    operator fun invoke(activityName: String): Boolean {
        val activityHashSha256 = ByteString.decodeHex(activityName.getSHA256Hash())

        return activityHashSha256 in activities
    }
}
