package com.unity3d.ads.core.data.datasource

import com.unity3d.ads.core.data.model.CacheError
import com.unity3d.ads.core.data.model.CacheResult
import com.unity3d.ads.core.data.model.CacheSource
import com.unity3d.ads.core.data.model.CachedFile
import com.unity3d.ads.core.domain.CreateFile
import com.unity3d.ads.core.domain.GetFileExtensionFromUrl
import java.io.File

class AndroidLocalCacheDataSource(val createFile: CreateFile, val getFileExtensionFromUrl: GetFileExtensionFromUrl) : CacheDataSource {
    override suspend fun getFile(
        cachePath: File,
        fileName: String,
        url: String?,
        priority: Int?
    ): CacheResult {
        val file = createFile(cachePath, fileName)
        return if (file.exists() && !file.name.endsWith(".part")) {
            val extension = if (url.isNullOrEmpty()) null else getFileExtensionFromUrl(url)
            val result = CachedFile(
                url = url ?: "",
                name = fileName,
                file = file,
                extension = extension ?: "",
                contentLength = file.length(),
                priority = priority ?: Int.MAX_VALUE
            )
            CacheResult.Success(result, CacheSource.LOCAL)
        } else {
            CacheResult.Failure(CacheError.FILE_NOT_FOUND, CacheSource.LOCAL)
        }
    }
}