/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.di.IServiceComponent;
import com.unity3d.services.core.di.IServiceProvider;
import com.unity3d.services.core.domain.ISDKDispatchers;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.network.core.HttpClient;
import com.unity3d.services.core.network.model.HttpRequest;
import com.unity3d.services.core.network.model.HttpResponse;
import com.unity3d.services.core.network.model.RequestType;
import com.unity3d.services.core.properties.InitializationStatusReader;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.MetricCommonTags;
import com.unity3d.services.core.request.metrics.MetricSenderBase;
import com.unity3d.services.core.request.metrics.MetricsContainer;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J.\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010 \u001a\u00020\u00182\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\"H\u0016J\u0006\u0010#\u001a\u00020\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0016*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/unity3d/services/core/request/metrics/MetricSender;", "Lcom/unity3d/services/core/request/metrics/MetricSenderBase;", "Lcom/unity3d/services/core/di/IServiceComponent;", "configuration", "Lcom/unity3d/services/core/configuration/Configuration;", "initializationStatusReader", "Lcom/unity3d/services/core/properties/InitializationStatusReader;", "(Lcom/unity3d/services/core/configuration/Configuration;Lcom/unity3d/services/core/properties/InitializationStatusReader;)V", "commonTags", "Lcom/unity3d/services/core/request/metrics/MetricCommonTags;", "dispatchers", "Lcom/unity3d/services/core/domain/ISDKDispatchers;", "httpClient", "Lcom/unity3d/services/core/network/core/HttpClient;", "metricEndPoint", "", "getMetricEndPoint", "()Ljava/lang/String;", "metricSampleRate", "scope", "Lkotlinx/coroutines/CoroutineScope;", "sessionToken", "kotlin.jvm.PlatformType", "sendEvent", "", "event", "value", "tags", "", "sendMetric", "metric", "Lcom/unity3d/services/core/request/metrics/Metric;", "sendMetrics", "metrics", "", "shutdown", "unity-ads_defaultRelease"})
@SourceDebugExtension(value={"SMAP\nMetricSender.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricSender.kt\ncom/unity3d/services/core/request/metrics/MetricSender\n+ 2 IServiceComponent.kt\ncom/unity3d/services/core/di/IServiceComponentKt\n+ 3 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,79:1\n16#2,4:80\n16#2,4:84\n49#3,4:88\n*S KotlinDebug\n*F\n+ 1 MetricSender.kt\ncom/unity3d/services/core/request/metrics/MetricSender\n*L\n25#1:80,4\n26#1:84,4\n53#1:88,4\n*E\n"})
public class MetricSender
extends MetricSenderBase
implements IServiceComponent {
    @NotNull
    private final MetricCommonTags commonTags;
    @NotNull
    private final String metricSampleRate;
    private final String sessionToken;
    @NotNull
    private final ISDKDispatchers dispatchers;
    @NotNull
    private final HttpClient httpClient;
    @NotNull
    private final CoroutineScope scope;
    @Nullable
    private final String metricEndPoint;

    /*
     * WARNING - void declaration
     */
    public MetricSender(@NotNull Configuration configuration, @NotNull InitializationStatusReader initializationStatusReader) {
        void it;
        MetricCommonTags metricCommonTags;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)initializationStatusReader, (String)"initializationStatusReader");
        super(initializationStatusReader);
        MetricCommonTags metricCommonTags2 = metricCommonTags = new MetricCommonTags();
        MetricSender metricSender = this;
        boolean bl = false;
        it.updateWithConfig(configuration);
        metricSender.commonTags = metricCommonTags;
        this.metricSampleRate = String.valueOf(MathKt.roundToInt((double)configuration.getMetricSampleRate()));
        this.sessionToken = configuration.getSessionToken();
        IServiceComponent $this$get_u24default$iv = this;
        String named$iv = "";
        boolean $i$f$get = false;
        this.dispatchers = (ISDKDispatchers)$this$get_u24default$iv.getServiceProvider().getRegistry().getService(named$iv, Reflection.getOrCreateKotlinClass(ISDKDispatchers.class));
        $this$get_u24default$iv = this;
        named$iv = "";
        $i$f$get = false;
        this.httpClient = (HttpClient)$this$get_u24default$iv.getServiceProvider().getRegistry().getService(named$iv, Reflection.getOrCreateKotlinClass(HttpClient.class));
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)this.dispatchers.getIo()));
        this.metricEndPoint = configuration.getMetricsUrl();
    }

    @Override
    @Nullable
    public String getMetricEndPoint() {
        return this.metricEndPoint;
    }

    @Override
    public void sendEvent(@NotNull String event, @Nullable String value, @NotNull Map<String, String> tags) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(tags, (String)"tags");
        if (((CharSequence)event).length() == 0) {
            DeviceLog.debug("Metric event not sent due to being null or empty: " + event);
            return;
        }
        this.sendMetrics(CollectionsKt.listOf((Object)new Metric(event, value, tags)));
    }

    @Override
    public void sendMetric(@NotNull Metric metric) {
        Intrinsics.checkNotNullParameter((Object)metric, (String)"metric");
        this.sendMetrics(CollectionsKt.listOf((Object)metric));
    }

    @Override
    public void sendMetrics(@NotNull List<Metric> metrics) {
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        if (metrics.isEmpty()) {
            DeviceLog.debug("Metrics event not send due to being empty");
            return;
        }
        CharSequence charSequence = this.getMetricEndPoint();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            DeviceLog.debug("Metrics: " + metrics + " was not sent to null or empty endpoint: " + this.getMetricEndPoint());
            return;
        }
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key = CoroutineExceptionHandler.Key;
        CoroutineExceptionHandler errorHandler = new CoroutineExceptionHandler(key, metrics){
            final /* synthetic */ List $metrics$inlined;
            {
                this.$metrics$inlined = list;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable throwable = exception;
                boolean bl = false;
                DeviceLog.debug("Metric " + this.$metrics$inlined + " failed to send with error: " + throwable);
            }
        };
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)((CoroutineContext)errorHandler), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, metrics, null){
            int label;
            final /* synthetic */ MetricSender this$0;
            final /* synthetic */ List<Metric> $metrics;
            {
                this.this$0 = $receiver;
                this.$metrics = $metrics;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        container = new MetricsContainer(MetricSender.access$getMetricSampleRate$p(this.this$0), MetricSender.access$getCommonTags$p(this.this$0), this.$metrics, MetricSender.access$getSessionToken$p(this.this$0));
                        var4_4 = new JSONObject(container.toMap()).toString();
                        Intrinsics.checkNotNullExpressionValue((Object)var4_4, (String)"JSONObject(container.toMap()).toString()");
                        postBody = var4_4;
                        v0 = this.this$0.getMetricEndPoint();
                        if (v0 == null) {
                            v0 = "";
                        }
                        request = new HttpRequest(v0, null, RequestType.POST, var3_5, null, null, null, null, null, 0, 0, 0, 0, false, null, null, 0, 131058, null);
                        this.label = 1;
                        v1 = MetricSender.access$getHttpClient$p(this.this$0).execute(request, (Continuation<? super HttpResponse>)((Continuation)this));
                        if (v1 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl21
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        v2 = is2XXResponseCode = (response = (HttpResponse)v1).getStatusCode() / 100 == 2;
                        if (is2XXResponseCode) {
                            DeviceLog.debug("Metric " + this.$metrics + " sent to " + this.this$0.getMetricEndPoint());
                        } else {
                            DeviceLog.debug("Metric " + this.$metrics + " failed to send with response code: " + response.getStatusCode());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void shutdown() {
        this.commonTags.shutdown();
    }

    @Override
    @NotNull
    public IServiceProvider getServiceProvider() {
        return IServiceComponent.DefaultImpls.getServiceProvider(this);
    }

    public static final /* synthetic */ String access$getMetricSampleRate$p(MetricSender $this) {
        return $this.metricSampleRate;
    }

    public static final /* synthetic */ MetricCommonTags access$getCommonTags$p(MetricSender $this) {
        return $this.commonTags;
    }

    public static final /* synthetic */ String access$getSessionToken$p(MetricSender $this) {
        return $this.sessionToken;
    }

    public static final /* synthetic */ HttpClient access$getHttpClient$p(MetricSender $this) {
        return $this.httpClient;
    }
}

