/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.cache;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import com.unity3d.services.core.api.Request;
import com.unity3d.services.core.cache.CacheError;
import com.unity3d.services.core.cache.CacheEvent;
import com.unity3d.services.core.cache.CacheEventSender;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.request.WebRequest;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CacheThreadHandler
extends Handler {
    private WebRequest _currentRequest = null;
    private boolean _canceled = false;
    private boolean _active = false;

    CacheThreadHandler() {
    }

    public void handleMessage(Message msg) {
        Bundle data = msg.getData();
        String source = data.getString("source");
        data.remove("source");
        String target = data.getString("target");
        data.remove("target");
        int connectTimeout = data.getInt("connectTimeout");
        data.remove("connectTimeout");
        int readTimeout = data.getInt("readTimeout");
        data.remove("readTimeout");
        int progressInterval = data.getInt("progressInterval");
        data.remove("progressInterval");
        boolean append = data.getBoolean("append", false);
        data.remove("append");
        CacheEventSender cacheEventSender = (CacheEventSender)data.getSerializable("cacheEventSender");
        data.remove("cacheEventSender");
        HashMap<String, List<String>> headers = null;
        if (data.size() > 0) {
            DeviceLog.debug("There are headers left in data, reading them");
            headers = new HashMap<String, List<String>>();
            for (String k : data.keySet()) {
                List<String> values = Arrays.asList(data.getStringArray(k));
                headers.put(k, values);
            }
        }
        File targetFile = new File(target);
        if (append && !targetFile.exists() || !append && targetFile.exists()) {
            this._active = false;
            cacheEventSender.sendEvent(CacheEvent.DOWNLOAD_ERROR, new Object[]{CacheError.FILE_STATE_WRONG, source, target, append, targetFile.exists()});
            return;
        }
        switch (msg.what) {
            case 1: {
                this.downloadFile(source, target, connectTimeout, readTimeout, progressInterval, headers, append, cacheEventSender);
                break;
            }
        }
    }

    public void setCancelStatus(boolean canceled) {
        this._canceled = canceled;
        if (canceled && this._currentRequest != null) {
            this._active = false;
            this._currentRequest.cancel();
        }
    }

    public boolean isActive() {
        return this._active;
    }

    /*
     * Exception decompiling
     */
    private void downloadFile(String source, String target, int connectTimeout, int readTimeout, int progressInterval, HashMap<String, List<String>> headers, boolean append, CacheEventSender cacheThreadBinder) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void postProcessDownload(long startTime, String source, File targetFile, long byteCount, long totalBytes, boolean canceled, int responseCode, Map<String, List<String>> responseHeaders, CacheEventSender cacheEventSender) {
        long duration = SystemClock.elapsedRealtime() - startTime;
        boolean result2 = targetFile.setReadable(true, false);
        if (!result2) {
            DeviceLog.debug("Unity Ads cache: could not set file readable!");
        }
        if (!canceled) {
            DeviceLog.debug("Unity Ads cache: File " + targetFile.getName() + " of " + byteCount + " bytes downloaded in " + duration + "ms");
            cacheEventSender.sendEvent(CacheEvent.DOWNLOAD_END, source, byteCount, totalBytes, duration, responseCode, Request.getResponseHeadersMap(responseHeaders));
        } else {
            DeviceLog.debug("Unity Ads cache: downloading of " + source + " stopped");
            cacheEventSender.sendEvent(CacheEvent.DOWNLOAD_STOPPED, source, byteCount, totalBytes, duration, responseCode, Request.getResponseHeadersMap(responseHeaders));
        }
    }

    private WebRequest getWebRequest(String source, int connectTimeout, int readTimeout, HashMap<String, List<String>> headers) throws MalformedURLException {
        HashMap<String, List<String>> requestHeaders = new HashMap<String, List<String>>();
        if (headers != null) {
            requestHeaders.putAll(headers);
        }
        return new WebRequest(source, "GET", requestHeaders, connectTimeout, readTimeout);
    }
}

