/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import android.annotation.TargetApi;
import android.app.Application;
import com.unity3d.services.core.lifecycle.LifecycleError;
import com.unity3d.services.core.lifecycle.LifecycleListener;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;

@TargetApi(value=14)
public class Lifecycle {
    private static LifecycleListener _listener;

    @WebViewExposed
    public static void register(JSONArray events2, WebViewCallback callback2) {
        if (ClientProperties.getApplication() != null) {
            if (Lifecycle.getLifecycleListener() == null) {
                ArrayList<String> eventList = new ArrayList<String>();
                for (int i = 0; i < events2.length(); ++i) {
                    try {
                        eventList.add((String)events2.get(i));
                        continue;
                    }
                    catch (JSONException e) {
                        callback2.error(LifecycleError.JSON_ERROR, new Object[0]);
                        return;
                    }
                }
                Lifecycle.setLifecycleListener(new LifecycleListener(eventList));
                ClientProperties.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Lifecycle.getLifecycleListener());
                callback2.invoke(new Object[0]);
            } else {
                callback2.error(LifecycleError.LISTENER_NOT_NULL, new Object[0]);
            }
        } else {
            callback2.error(LifecycleError.APPLICATION_NULL, new Object[0]);
        }
    }

    @WebViewExposed
    public static void unregister(WebViewCallback callback2) {
        if (ClientProperties.getApplication() != null) {
            if (Lifecycle.getLifecycleListener() != null) {
                ClientProperties.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)Lifecycle.getLifecycleListener());
                Lifecycle.setLifecycleListener(null);
            }
            callback2.invoke(new Object[0]);
        } else {
            callback2.error(LifecycleError.APPLICATION_NULL, new Object[0]);
        }
    }

    public static LifecycleListener getLifecycleListener() {
        return _listener;
    }

    public static void setLifecycleListener(LifecycleListener listener2) {
        _listener = listener2;
    }
}

