package com.unity3d.services.store.gpbl.bridges.billingclient.v8

import com.unity3d.services.core.reflection.GenericBridge

class ProductBuilderBridge(private var builderInstance: Any
): GenericBridge(
    mapOf(
        SET_PRODUCT_ID_METHOD to arrayOf(String::class.java),
        SET_PRODUCT_TYPE_METHOD to arrayOf(String::class.java),
        BUILD_METHOD to emptyArray()
    )
) {
    fun build(): ProductBridge {
        val product = callNonVoidMethod<Any>(BUILD_METHOD, builderInstance)
        return ProductBridge(product)
    }

    fun setProductType(productType: String): ProductBuilderBridge {
        builderInstance = callNonVoidMethod(SET_PRODUCT_TYPE_METHOD, builderInstance, productType)
        return this
    }

    fun setProductId(productId: String): ProductBuilderBridge {
        builderInstance = callNonVoidMethod(SET_PRODUCT_ID_METHOD, builderInstance, productId)
        return this
    }

    override fun getClassName(): String {
        return "com.android.billingclient.api.QueryProductDetailsParams\$Product\$Builder"
    }

    companion object {
        private const val SET_PRODUCT_ID_METHOD = "setProductId"
        private const val SET_PRODUCT_TYPE_METHOD = "setProductType"
        private const val BUILD_METHOD = "build"
    }
}