package com.unity3d.services.core.configuration

import android.app.Application
import android.content.Context
import androidx.startup.Initializer
import com.google.android.gms.net.CronetProviderInstaller
import com.unity3d.ads.core.data.repository.OrientationRepository
import com.unity3d.services.core.di.ServiceProvider
import com.unity3d.services.core.properties.ClientProperties
import com.unity3d.services.core.properties.SdkProperties
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

/**
 * Unity SDK Initializer implementation of Androidx.Startup - Initializer interface.
 */
class AdsSdkInitializer : Initializer<Unit> {
    override fun create(context: Context) {
        ClientProperties.setApplicationContext(context.applicationContext)
        if (context is Application) {
            ClientProperties.setApplication(context)
        } else if (context.applicationContext is Application) {
            val applicationContext = context.applicationContext as Application
            ClientProperties.setApplication(applicationContext)
        }
        SdkProperties.setAppInitializationTimeSinceEpoch(System.currentTimeMillis())

        // Register Resumed activity observer.
        //
        // This observer must be registered upon app start to make sure no
        // activityLifecycleCallbacks are missed, as registered observers will only receive new
        // events
        ServiceProvider.getRegistry().getService<OrientationRepository>(
            "",
            OrientationRepository::class
        ).invoke()

        // Start the installation for later use.
        try {
            CronetProviderInstaller.installProvider(context)
        } catch (e: Throwable) {
            // no-op
        }
    }

    override fun dependencies(): List<Class<out Initializer<*>>> {
        // No dependencies on other libraries.
        return emptyList()
    }
}