package com.unity3d.ads.adplayer.model

/**
 * This interface is used to bridge the communication between the WebView and the SDK code.
 */
interface WebViewBridgeInterface {
    /**
     * Handles an invocation from the webview. This is called by the webview when it wants to call a method on the SDK.
     */
    fun handleInvocation(message: String)

    /**
     * Handles a callback from the webview. This is called by the webview responding to a method call.
     */
    fun handleCallback(callbackId: String, callbackStatus: String, rawParameters: String)
}
