/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.store.gpbl.proxies;

import com.unity3d.services.core.reflection.GenericListenerProxy;
import com.unity3d.services.store.gpbl.bridges.BillingResultBridge;
import com.unity3d.services.store.gpbl.bridges.SkuDetailsBridge;
import com.unity3d.services.store.gpbl.listeners.SkuDetailsResponseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class SkuDetailsResponseListenerProxy
extends GenericListenerProxy {
    private static final String onSkuDetailsResponseMethodName = "onSkuDetailsResponse";
    private SkuDetailsResponseListener skuDetailsResponseListener;

    public SkuDetailsResponseListenerProxy(SkuDetailsResponseListener skuDetailsResponseListener) {
        this.skuDetailsResponseListener = skuDetailsResponseListener;
    }

    @Override
    public Class<?> getProxyClass() throws ClassNotFoundException {
        return SkuDetailsResponseListenerProxy.getProxyListenerClass();
    }

    public static Class<?> getProxyListenerClass() throws ClassNotFoundException {
        return Class.forName("com.android.billingclient.api.SkuDetailsResponseListener");
    }

    @Override
    public Object invoke(Object proxy, Method m, Object[] args) throws Throwable {
        Object result2 = null;
        if (m.getName().equals(onSkuDetailsResponseMethodName)) {
            this.onSkuDetailsResponse(args[0], (List)args[1]);
        } else {
            result2 = super.invoke(proxy, m, args);
        }
        return result2;
    }

    public void onSkuDetailsResponse(Object billingResult, List<Object> skuDetailsList) {
        ArrayList<SkuDetailsBridge> skuDetailsBridges = null;
        if (skuDetailsList != null) {
            skuDetailsBridges = new ArrayList<SkuDetailsBridge>();
            for (Object skuDetails : skuDetailsList) {
                skuDetailsBridges.add(new SkuDetailsBridge(skuDetails));
            }
        }
        if (this.skuDetailsResponseListener != null) {
            this.skuDetailsResponseListener.onSkuDetailsUpdated(new BillingResultBridge(billingResult), skuDetailsBridges);
        }
    }
}

