package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.repository.CacheRepository
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.SHOW_IS_FILE_CACHED_FAILURE
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.SHOW_IS_FILE_CACHED_SUCCESS
import com.unity3d.ads.core.extensions.elapsedMillis
import kotlin.time.ExperimentalTime
import kotlin.time.TimeSource

@OptIn(ExperimentalTime::class)
class CommonGetIsFileCache(
    private val cacheRepository: CacheRepository,
    private val sendDiagnosticEvent: SendDiagnosticEvent,
) : GetIsFileCache {
    override suspend fun invoke(url: String): Boolean {
        val startTime = TimeSource.Monotonic.markNow()
        val fileName = url.substringAfterLast("/")
        val isCached = cacheRepository.doesFileExist(fileName)
        sendDiagnosticEvent.invoke(
            event = if (isCached) SHOW_IS_FILE_CACHED_SUCCESS else SHOW_IS_FILE_CACHED_FAILURE,
            value = startTime.elapsedMillis(),
        )
        return isCached
    }
}