/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.request.metrics;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.unity3d.services.core.configuration.Configuration;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.InitializationStatusReader;
import com.unity3d.services.core.request.metrics.Metric;
import com.unity3d.services.core.request.metrics.MetricSender;
import com.unity3d.services.core.request.metrics.MetricSenderWithBatch;
import com.unity3d.services.core.request.metrics.SDKMetricsSender;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SDKMetrics {
    private static final String NULL_INSTANCE_METRICS_URL = "nullInstanceMetricsUrl";
    private static SDKMetricsSender _instance;
    private static MetricSenderWithBatch _batchedSender;
    private static final AtomicBoolean _configurationIsSet;

    public static void setConfiguration(Configuration configuration) {
        if (configuration == null) {
            DeviceLog.debug("Metrics will not be sent from the device for this session due to misconfiguration");
            return;
        }
        if (!SDKMetrics.isAllowedToSetConfiguration(configuration)) {
            return;
        }
        if (_instance instanceof MetricSender) {
            ((MetricSender)_instance).shutdown();
        }
        if (configuration.areMetricsEnabledForCurrentSession().booleanValue()) {
            _instance = new MetricSender(configuration, new InitializationStatusReader());
        } else {
            DeviceLog.debug("Metrics will not be sent from the device for this session");
            _instance = new NullInstance(NULL_INSTANCE_METRICS_URL);
        }
        if (_batchedSender == null) {
            _batchedSender = new MetricSenderWithBatch(_instance, new InitializationStatusReader());
        } else {
            _batchedSender.updateOriginal(_instance);
        }
        _batchedSender.sendQueueIfNeeded();
    }

    public static synchronized SDKMetricsSender getInstance() {
        if (_instance == null) {
            _instance = new NullInstance(null);
        }
        if (_batchedSender == null) {
            _batchedSender = new MetricSenderWithBatch(_instance, new InitializationStatusReader());
        }
        return _batchedSender;
    }

    private static boolean isAllowedToSetConfiguration(Configuration configuration) {
        return !TextUtils.isEmpty((CharSequence)configuration.getMetricsUrl()) && _configurationIsSet.compareAndSet(false, true);
    }

    static {
        _configurationIsSet = new AtomicBoolean(false);
    }

    private static final class NullInstance
    implements SDKMetricsSender {
        private final String _metricEndpoint;

        public NullInstance(String url) {
            this._metricEndpoint = url;
        }

        @Override
        public void sendEvent(@NonNull String event) {
            DeviceLog.debug("Metric " + event + " was skipped from being sent");
        }

        @Override
        public void sendEvent(@NonNull String event, String value, Map<String, String> tags) {
            this.sendEvent(event);
        }

        public void sendEvent(@NonNull String event, Map<String, String> tags) {
            this.sendEvent(event);
        }

        @Override
        public void sendMetric(@NonNull Metric metric) {
            DeviceLog.debug("Metric " + metric + " was skipped from being sent");
        }

        @Override
        public void sendMetrics(@NonNull List<Metric> metrics) {
            DeviceLog.debug("Metrics: " + metrics + " was skipped from being sent");
        }

        @Override
        public void sendMetricWithInitState(Metric metric) {
            this.sendMetric(metric);
        }

        @Override
        public String getMetricEndPoint() {
            return this._metricEndpoint;
        }
    }
}

