package com.unity3d.ads.core.extensions

import com.unity3d.ads.UnityAds.UnityAdsShowCompletionState
import com.unity3d.ads.adplayer.model.ShowStatus
import gatewayprotocol.v1.NativeConfigurationOuterClass.ShowCompletionState

fun ShowStatus.toUnityAdsShowCompletionState(defaultShowCompletionState: ShowCompletionState) = when (this) {
    ShowStatus.COMPLETED -> UnityAdsShowCompletionState.COMPLETED
    ShowStatus.SKIPPED -> UnityAdsShowCompletionState.SKIPPED
    ShowStatus.ERROR -> when (defaultShowCompletionState) {
        ShowCompletionState.SHOW_COMPLETION_STATE_COMPLETED -> UnityAdsShowCompletionState.COMPLETED
        ShowCompletionState.SHOW_COMPLETION_STATE_SKIPPED -> UnityAdsShowCompletionState.SKIPPED
        else -> UnityAdsShowCompletionState.COMPLETED
    }
}
