package com.unity3d.ads.core.data.repository

import com.unity3d.ads.core.data.model.CacheResult
import com.unity3d.ads.core.data.model.CachedFile
import org.json.JSONArray

interface CacheRepository {
    suspend fun getFile(url: String, headers: JSONArray? = null, priority: Int = 0): CacheResult
    suspend fun getWebviewFile(url: String, type: String): CacheResult
    fun removeFile(cachedFile: CachedFile): Boolean
    suspend fun doesFileExist(fileName: String): Boolean
    suspend fun retrieveFile(fileName: String): CacheResult
    suspend fun clearCache()
    suspend fun getCacheSize(): Long
}
