package com.unity3d.ads.core.data.datasource

import android.content.Context
import com.unity3d.services.core.fid.FIdStaticBridge
import kotlinx.coroutines.runBlocking
import kotlin.coroutines.resume
import kotlin.coroutines.resumeWithException
import kotlin.coroutines.suspendCoroutine

class AndroidFIdDataSource(
    private val context: Context
): FIdDataSource {
    private var bridge: FIdStaticBridge = FIdStaticBridge()

    override fun invoke(): String? {
        return runCatching {
            val task = bridge.getInstance(context)?.getAppInstanceId() ?: return null
            return runBlocking {
                    suspendCoroutine { cont ->
                        task.addOnSuccessListener { id ->
                            cont.resume(id)
                        }
                        task.addOnFailureListener {
                            cont.resumeWithException(it)
                        }
                    }
            }
        }.getOrNull()
    }
}