package com.unity3d.ads.beta

internal class LoadOptions(
   val placementId: String,
   val adMarkup: String? = null,
   val extras: Map<String, String> = emptyMap(),
) {
    class Builder(private val placementId: String) {
        private var adMarkup: String? = null
        private val extras: MutableMap<String, String> = mutableMapOf()

        fun withAdMarkup(adMarkup: String): Builder {
            this.adMarkup = adMarkup
            return this
        }

        fun withExtras(extras: Map<String, String>): Builder {
            this.extras.putAll(extras)
            return this
        }

        fun build(): LoadOptions {
            return LoadOptions(placementId, adMarkup, extras)
        }
    }
}
