package com.unity3d.ads.core.data.model

import com.google.protobuf.ByteString
import com.unity3d.ads.UnityAdsLoadOptions
import com.unity3d.ads.adplayer.AdPlayer
import gatewayprotocol.v1.DiagnosticEventRequestOuterClass.DiagnosticAdType

data class AdObject (
    val opportunityId: ByteString,
    val placementId: String,
    var trackingToken: ByteString,
    var isScarAd: Boolean = false,
    var scarQueryId: String? = null,
    var scarAdUnitId: String? = null,
    var scarAdString: String? = null,
    var isOfferwallAd: Boolean = false,
    var offerwallPlacementName: String? = null,
    val adPlayer: AdPlayer? = null,
    var playerServerId: String? = null,
    val loadOptions: UnityAdsLoadOptions,
    val isHeaderBidding: Boolean,
    val adType: DiagnosticAdType
)