package com.unity3d.services

import com.unity3d.ads.BuildConfig
import com.unity3d.services.UnityAdsConstants.Cache.CACHE_SCHEME
import com.unity3d.services.UnityAdsConstants.DefaultUrls.AD_ASSET_DOMAIN

object UnityAdsConstants {

    object Messages {
        const val MSG_UNITY_BASE = "[Unity Ads] "
        const val MSG_INTERNAL_ERROR = "Internal error"
    }

    object Timeout {
        const val INIT_TIMEOUT_MS = 120_000L
    }

    object RequestPolicy {
        const val RETRY_MAX_DURATION = 120_000
        const val RETRY_MAX_INTERVAL = 2_500
        const val RETRY_SCALING_FACTOR = 2.0f
        const val RETRY_WAIT_BASE = 500
        const val RETRY_JITTER_PCT = 0.1f
        const val CONNECT_TIMEOUT_MS = 30_000
        const val OVERALL_TIMEOUT_MS = 30_000
        const val READ_TIMEOUT_MS = 30_000
        const val WRITE_TIMEOUT_MS = 30_000
        const val SHOULD_STORE_LOCALLY = false
    }

    object SharedFlow {
        const val REPLAY = 10
        const val EXTRA_CAPACITY = 10
    }

    object DefaultUrls {
        const val GATEWAY_URL = "https://gateway.unityads.unity3d.com/v1"
        const val WEBVIEW_DOMAIN = "webview.unityads.unity3d.com"
        const val WEBVIEW_ASSET_PATH = "/unity-ads-sdk-webview/"
        const val WEBVIEW_ASSET_PATH_LOCAL = "ad-viewer/"
        const val AD_CACHE_DOMAIN = "unity.ads.cache"
        const val AD_ASSET_DOMAIN = "unity.ads.asset"
        const val AD_PLAYER_QUERY_PARAMS = "?platform=android&"
        const val CACHE_DIR_NAME = "UnityAdsCache"
        const val HTTP_CACHE_DIR_NAME = "UnityAdsHttpCache"
        const val HTTP_CACHE_OK_HTTP_DIR_NAME = "UnityAdsOkHttpCache"
    }

    object ClientInfo {
        const val SDK_VERSION = BuildConfig.VERSION_CODE
        const val SDK_VERSION_NAME = BuildConfig.VERSION_NAME
    }

    object OpenMeasurement {
        const val OM_PARTNER_NAME = "Unity3d"
        const val OM_PARTNER_VERSION = "1"
        const val OM_JS_SESSION_FILENAME = "ad-viewer/omid-session-client-v1.js"
        const val OM_JS_SERVICE_FILENAME = "ad-viewer/omsdk-v1.js"
        const val OM_JS_URL_SESSION = "$CACHE_SCHEME://$AD_ASSET_DOMAIN/$OM_JS_SESSION_FILENAME"
        const val OM_JS_URL_SERVICE = "$CACHE_SCHEME://$AD_ASSET_DOMAIN/$OM_JS_SERVICE_FILENAME"
        const val OM_SESSION_FINISH_DELAY_MS = 1000L
    }

    object Cache {
        const val CACHE_SCHEME = "unity-ads-cache"
        const val DATASTORE_PATH = "unityAdsDatastore/"
    }

    object AdOperations {
        const val LOAD_TIMEOUT_MS = 30000
        const val SHOW_TIMEOUT_MS = 10000
        const val GET_TOKEN_TIMEOUT_MS = 750
    }

    object Preferences {
        const val PREF_NAME_IDFI = "unityads-installinfo"
        const val PREF_NAME_AUID = "supersonic_shared_preferen"
        const val PREF_KEY_IDFI = "unityads-idfi"
        const val PREF_KEY_AUID = "auid"
    }

    object ErrorHandler {
        const val ERROR_HANDLER_STACK_TRACE_LINES_MAX = 15
    }
}
