package com.unity3d.ads.gl

import android.opengl.EGL14

/**
 * Base class for EGL surface
 */
open class EglSurfaceBase protected constructor(eglCore: EglCore) {
    private var mEglCore: EglCore
    private var mEGLSurface = EGL14.EGL_NO_SURFACE
    private var mWidth = -1
    private var mHeight = -1

    init {
        mEglCore = eglCore
    }

    /**
     * Creates an off-screen surface.
     */
    fun createOffscreenSurface(width: Int, height: Int) {
        check(!(mEGLSurface !== EGL14.EGL_NO_SURFACE)) { "surface already created" }
        mEGLSurface = mEglCore.createOffscreenSurface(width, height)
        mWidth = width
        mHeight = height
    }

    /**
     * Release the EGL surface.
     */
    fun releaseEglSurface() {
        mEglCore.releaseSurface(mEGLSurface)
        mEGLSurface = EGL14.EGL_NO_SURFACE
        mHeight = -1
        mWidth = mHeight
    }

    /**
     * Makes our EGL context and surface current.
     */
    fun makeCurrent() = mEglCore.makeCurrent(mEGLSurface)
}