/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.common.signals;

import com.unity3d.scar.adapter.common.DispatchGroup;
import com.unity3d.scar.adapter.common.signals.ISignalCallbackListener;
import com.unity3d.scar.adapter.common.signals.SignalsResult;
import com.unity3d.scar.adapter.common.signals.SignalsStorage;

public class SignalCallbackListener<T>
implements ISignalCallbackListener<T> {
    private DispatchGroup _dispatchGroup;
    private SignalsStorage<T> _signalsStorage;
    private SignalsResult _signalsResult;

    public SignalCallbackListener(DispatchGroup dispatchGroup, SignalsResult signalsResult) {
        this(dispatchGroup, null, signalsResult);
    }

    public SignalCallbackListener(DispatchGroup dispatchGroup, SignalsStorage<T> signalsStorage, SignalsResult signalsResult) {
        this._dispatchGroup = dispatchGroup;
        this._signalsStorage = signalsStorage;
        this._signalsResult = signalsResult;
    }

    @Override
    public void onSuccess(String placementId, String signal, T queryInfo) {
        this._signalsResult.addToSignalsMap(placementId, signal);
        if (this._signalsStorage != null) {
            this._signalsStorage.put(placementId, queryInfo);
        }
        this._dispatchGroup.leave();
    }

    @Override
    public void onFailure(String errorMessage) {
        this._signalsResult.setErrorMessage(errorMessage);
        this._dispatchGroup.leave();
    }
}

