/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.scar.adapter.v2000.scarads;

import android.content.Context;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.query.AdInfo;
import com.google.android.gms.ads.query.QueryInfo;
import com.unity3d.scar.adapter.common.GMAAdsError;
import com.unity3d.scar.adapter.common.IAdsErrorHandler;
import com.unity3d.scar.adapter.common.IUnityAdsError;
import com.unity3d.scar.adapter.common.scarads.IScarAd;
import com.unity3d.scar.adapter.common.scarads.IScarLoadListener;
import com.unity3d.scar.adapter.common.scarads.ScarAdMetadata;
import com.unity3d.scar.adapter.v2000.scarads.ScarAdListener;

public abstract class ScarAdBase<T>
implements IScarAd {
    protected T _adObj;
    protected Context _context;
    protected ScarAdMetadata _scarAdMetadata;
    protected QueryInfo _queryInfo;
    protected ScarAdListener _scarAdListener;
    protected IAdsErrorHandler _adsErrorHandler;

    public ScarAdBase(Context context, ScarAdMetadata scarAdMetadata, QueryInfo queryInfo, IAdsErrorHandler adsErrorHandler) {
        this._context = context;
        this._scarAdMetadata = scarAdMetadata;
        this._queryInfo = queryInfo;
        this._adsErrorHandler = adsErrorHandler;
    }

    public void setGmaAd(T rewardedAd) {
        this._adObj = rewardedAd;
    }

    public void loadAd(IScarLoadListener loadListener) {
        if (this._queryInfo != null) {
            AdInfo adInfo = new AdInfo(this._queryInfo, this._scarAdMetadata.getAdString());
            AdRequest adRequest = new AdRequest.Builder().setAdInfo(adInfo).build();
            if (loadListener != null) {
                this._scarAdListener.setLoadListener(loadListener);
            }
            this.loadAdInternal(adRequest, loadListener);
        } else {
            this._adsErrorHandler.handleError((IUnityAdsError)GMAAdsError.QueryNotFoundError((ScarAdMetadata)this._scarAdMetadata));
        }
    }

    protected abstract void loadAdInternal(AdRequest var1, IScarLoadListener var2);
}

