/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import com.unity3d.services.core.configuration.InitializeThread;
import com.unity3d.services.core.configuration.PrivacyConfigStorage;
import com.unity3d.services.core.device.Device;
import com.unity3d.services.core.log.DeviceLog;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.properties.SdkProperties;
import com.unity3d.services.core.properties.Session;
import com.unity3d.services.core.webview.WebViewApp;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;

public class Sdk {
    @WebViewExposed
    public static void loadComplete(WebViewCallback callback2) {
        DeviceLog.debug("Web Application loaded");
        WebViewApp.getCurrentApp().setWebAppLoaded(true);
        Object[] parameters = new Object[]{ClientProperties.getGameId(), SdkProperties.isTestMode(), ClientProperties.getAppName(), ClientProperties.getAppVersion(), SdkProperties.getVersionCode(), SdkProperties.getVersionName(), ClientProperties.isAppDebuggable(), SdkProperties.getConfigUrl(), WebViewApp.getCurrentApp().getConfiguration().getWebViewUrl(), WebViewApp.getCurrentApp().getConfiguration().getWebViewHash(), WebViewApp.getCurrentApp().getConfiguration().getWebViewVersion(), SdkProperties.getInitializationTime(), SdkProperties.isReinitialized(), true, SdkProperties.getLatestConfiguration() != null, Device.getElapsedRealtime(), WebViewApp.getCurrentApp().getConfiguration().getStateId(), PrivacyConfigStorage.getInstance().getPrivacyConfig().getPrivacyStatus().toLowerCase()};
        callback2.invoke(parameters);
    }

    @WebViewExposed
    public static void initComplete(WebViewCallback callback2) {
        DeviceLog.debug("Web Application initialized");
        SdkProperties.setInitialized(true);
        WebViewApp.getCurrentApp().setWebAppInitialized(true);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void initError(String message, Integer code, WebViewCallback callback2) {
        WebViewApp.getCurrentApp().setWebAppFailureMessage(message);
        WebViewApp.getCurrentApp().setWebAppFailureCode(code);
        WebViewApp.getCurrentApp().setWebAppInitialized(false);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getTrrData(WebViewCallback callback2) {
        callback2.invoke(WebViewApp.getCurrentApp().getConfiguration().getRawConfigData().toString());
    }

    @WebViewExposed
    public static void getSharedSessionID(WebViewCallback callback2) {
        callback2.invoke(Session.Default.getId());
    }

    @WebViewExposed
    public static void setDebugMode(Boolean debugMode, WebViewCallback callback2) {
        SdkProperties.setDebugMode(debugMode);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void getDebugMode(WebViewCallback callback2) {
        callback2.invoke(SdkProperties.getDebugMode());
    }

    @WebViewExposed
    public static void logError(String message, WebViewCallback callback2) {
        DeviceLog.error(message);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logWarning(String message, WebViewCallback callback2) {
        DeviceLog.warning(message);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logInfo(String message, WebViewCallback callback2) {
        DeviceLog.info(message);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void logDebug(String message, WebViewCallback callback2) {
        DeviceLog.debug(message);
        callback2.invoke(new Object[0]);
    }

    @WebViewExposed
    public static void reinitialize(WebViewCallback callback2) {
        SdkProperties.setReinitialized(true);
        InitializeThread.initialize(WebViewApp.getCurrentApp().getConfiguration());
    }

    @WebViewExposed
    public static void downloadLatestWebView(WebViewCallback callback2) {
        DeviceLog.debug("Unity Ads init: WebView called download");
        callback2.invoke(InitializeThread.downloadLatestWebView().getValue());
    }
}

