/*
 * Decompiled with CFR 0.152.
 */
package com.unity3d.services.core.api;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import com.unity3d.services.ads.adunit.AdUnitError;
import com.unity3d.services.ads.api.AdUnit;
import com.unity3d.services.core.api.PermissionsError;
import com.unity3d.services.core.device.DeviceError;
import com.unity3d.services.core.properties.ClientProperties;
import com.unity3d.services.core.webview.bridge.WebViewCallback;
import com.unity3d.services.core.webview.bridge.WebViewExposed;
import java.util.ArrayList;
import org.json.JSONArray;

public class Permissions {
    @WebViewExposed
    public static void getPermissions(WebViewCallback callback2) {
        if (ClientProperties.getApplicationContext() == null) {
            callback2.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
            return;
        }
        try {
            JSONArray retArray = new JSONArray();
            Context context = ClientProperties.getApplicationContext();
            PackageInfo info = context.getPackageManager().getPackageInfo(context.getPackageName(), 4096);
            if (info.requestedPermissions != null) {
                for (String p : info.requestedPermissions) {
                    retArray.put((Object)p);
                }
                callback2.invoke(retArray);
            } else {
                callback2.error(PermissionsError.NO_REQUESTED_PERMISSIONS, new Object[0]);
            }
        }
        catch (Exception e) {
            callback2.error(PermissionsError.COULDNT_GET_PERMISSIONS, e.getMessage());
        }
    }

    @WebViewExposed
    public static void checkPermission(String permission, WebViewCallback callback2) {
        if (ClientProperties.getApplicationContext() == null) {
            callback2.error(DeviceError.APPLICATION_CONTEXT_NULL, new Object[0]);
            return;
        }
        try {
            Context context = ClientProperties.getApplicationContext();
            int granted = context.getPackageManager().checkPermission(permission, context.getPackageName());
            callback2.invoke(granted);
        }
        catch (Exception e) {
            callback2.error(PermissionsError.ERROR_CHECKING_PERMISSION, e.getMessage());
        }
    }

    @WebViewExposed
    @TargetApi(value=23)
    public static void requestPermissions(JSONArray permissions, Integer requestCode, WebViewCallback callback2) {
        if (AdUnit.getAdUnitActivity() == null) {
            callback2.error(AdUnitError.ADUNIT_NULL, new Object[0]);
            return;
        }
        if (permissions == null || permissions.length() < 1) {
            callback2.error(PermissionsError.NO_REQUESTED_PERMISSIONS, new Object[0]);
            return;
        }
        try {
            ArrayList<String> permissionsList = new ArrayList<String>();
            for (int i = 0; i < permissions.length(); ++i) {
                permissionsList.add(permissions.getString(i));
            }
            String[] permissionsArray = new String[permissionsList.size()];
            AdUnit.getAdUnitActivity().requestPermissions(permissionsList.toArray(permissionsArray), requestCode);
            callback2.invoke(new Object[0]);
        }
        catch (Exception e) {
            callback2.error(PermissionsError.ERROR_REQUESTING_PERMISSIONS, e.getMessage());
        }
    }
}

