package com.unity3d.services.core.di

import androidx.datastore.core.DataMigration
import com.unity3d.ads.adplayer.AdPlayerScope
import com.unity3d.ads.adplayer.AndroidWebViewClient
import com.unity3d.ads.adplayer.CommonGetWebViewCacheAssetLoader
import com.unity3d.ads.adplayer.GetWebViewCacheAssetLoader
import com.unity3d.ads.core.configuration.AlternativeFlowReader
import com.unity3d.ads.core.configuration.AndroidManifestIntPropertyReader
import com.unity3d.ads.core.configuration.GameServerIdReader
import com.unity3d.ads.core.data.datasource.AnalyticsDataSource
import com.unity3d.ads.core.data.datasource.AndroidDeveloperConsentDataSource
import com.unity3d.ads.core.data.datasource.AndroidDynamicDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.AndroidLegacyConfigStoreDataSource
import com.unity3d.ads.core.data.datasource.AndroidLegacyUserConsentDataSource
import com.unity3d.ads.core.data.datasource.AndroidLifecycleDataSource
import com.unity3d.ads.core.data.datasource.AndroidLocalCacheDataSource
import com.unity3d.ads.core.data.datasource.AndroidMediationDataSource
import com.unity3d.ads.core.data.datasource.AndroidPrivacyDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.AndroidRemoteCacheDataSource
import com.unity3d.ads.core.data.datasource.AndroidStaticDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.AndroidStoreDataSource
import com.unity3d.ads.core.data.datasource.AndroidTcfDataSource
import com.unity3d.ads.core.data.datasource.ByteStringDataSource
import com.unity3d.ads.core.data.datasource.CacheDataSource
import com.unity3d.ads.core.data.datasource.DeveloperConsentDataSource
import com.unity3d.ads.core.data.datasource.DynamicDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.FetchGLInfoDataMigration
import com.unity3d.ads.core.data.datasource.LegacyUserConsentDataSource
import com.unity3d.ads.core.data.datasource.LifecycleDataSource
import com.unity3d.ads.core.data.datasource.MediationDataSource
import com.unity3d.ads.core.data.datasource.PrivacyDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.StaticDeviceInfoDataSource
import com.unity3d.ads.core.data.datasource.StoreDataSource
import com.unity3d.ads.core.data.datasource.TcfDataSource
import com.unity3d.ads.core.data.datasource.UniversalRequestDataSource
import com.unity3d.ads.core.data.datasource.WebviewConfigurationDataSource
import com.unity3d.ads.core.data.manager.AndroidOmidManager
import com.unity3d.ads.core.data.manager.AndroidSDKPropertiesManager
import com.unity3d.ads.core.data.manager.AndroidScarManager
import com.unity3d.ads.core.data.manager.AndroidStorageManager
import com.unity3d.ads.core.data.manager.OmidManager
import com.unity3d.ads.core.data.manager.SDKPropertiesManager
import com.unity3d.ads.core.data.manager.ScarManager
import com.unity3d.ads.core.data.manager.TransactionEventManager
import com.unity3d.ads.core.data.repository.AdRepository
import com.unity3d.ads.core.data.repository.AndroidAdRepository
import com.unity3d.ads.core.data.repository.AndroidCacheRepository
import com.unity3d.ads.core.data.repository.AndroidCampaignRepository
import com.unity3d.ads.core.data.repository.AndroidDeveloperConsentRepository
import com.unity3d.ads.core.data.repository.AndroidDeviceInfoRepository
import com.unity3d.ads.core.data.repository.AndroidDiagnosticEventRepository
import com.unity3d.ads.core.data.repository.AndroidLegacyUserConsentRepository
import com.unity3d.ads.core.data.repository.AndroidMediationRepository
import com.unity3d.ads.core.data.repository.AndroidOpenMeasurementRepository
import com.unity3d.ads.core.data.repository.AndroidSessionRepository
import com.unity3d.ads.core.data.repository.AndroidTcfRepository
import com.unity3d.ads.core.data.repository.AndroidTransactionEventRepository
import com.unity3d.ads.core.data.repository.CacheRepository
import com.unity3d.ads.core.data.repository.CampaignRepository
import com.unity3d.ads.core.data.repository.DeveloperConsentRepository
import com.unity3d.ads.core.data.repository.DeviceInfoRepository
import com.unity3d.ads.core.data.repository.DiagnosticEventRepository
import com.unity3d.ads.core.data.repository.LegacyUserConsentRepository
import com.unity3d.ads.core.data.repository.MediationRepository
import com.unity3d.ads.core.data.repository.OpenMeasurementRepository
import com.unity3d.ads.core.data.repository.OperativeEventRepository
import com.unity3d.ads.core.data.repository.SessionRepository
import com.unity3d.ads.core.data.repository.TcfRepository
import com.unity3d.ads.core.data.repository.TransactionEventRepository
import com.unity3d.ads.core.domain.AndroidBuildHeaderBiddingToken
import com.unity3d.ads.core.domain.AndroidExecuteAdViewerRequest
import com.unity3d.ads.core.domain.AndroidGenerateByteStringId
import com.unity3d.ads.core.domain.AndroidGetAdDataRefreshRequest
import com.unity3d.ads.core.domain.AndroidGetAdPlayerConfigRequest
import com.unity3d.ads.core.domain.AndroidGetAdPlayerContext
import com.unity3d.ads.core.domain.AndroidGetAdRequest
import com.unity3d.ads.core.domain.AndroidGetAdRequestPolicy
import com.unity3d.ads.core.domain.AndroidGetClientInfo
import com.unity3d.ads.core.domain.AndroidGetInitializationCompletedRequest
import com.unity3d.ads.core.domain.AndroidGetInitializationData
import com.unity3d.ads.core.domain.AndroidGetInitializationRequest
import com.unity3d.ads.core.domain.AndroidGetInitializationRequestPayload
import com.unity3d.ads.core.domain.AndroidGetLimitedSessionToken
import com.unity3d.ads.core.domain.AndroidGetOpenGLRendererInfo
import com.unity3d.ads.core.domain.AndroidGetSharedDataTimestamps
import com.unity3d.ads.core.domain.AndroidGetUniversalRequestForPayLoad
import com.unity3d.ads.core.domain.AndroidGetUniversalRequestSharedData
import com.unity3d.ads.core.domain.AndroidGetWebViewContainerUseCase
import com.unity3d.ads.core.domain.AndroidHandleGatewayAdResponse
import com.unity3d.ads.core.domain.AndroidHandleGatewayInitializationResponse
import com.unity3d.ads.core.domain.AndroidHandleGatewayUniversalResponse
import com.unity3d.ads.core.domain.AndroidHandleOpenUrl
import com.unity3d.ads.core.domain.AndroidHttpClientProvider
import com.unity3d.ads.core.domain.AndroidInitializeBoldSDK
import com.unity3d.ads.core.domain.AndroidLoad
import com.unity3d.ads.core.domain.AndroidRefresh
import com.unity3d.ads.core.domain.AndroidRemoveUrlQuery
import com.unity3d.ads.core.domain.AndroidSendDiagnosticEvent
import com.unity3d.ads.core.domain.AndroidSendWebViewClientErrorDiagnostics
import com.unity3d.ads.core.domain.AndroidShow
import com.unity3d.ads.core.domain.AndroidTestDataInfo
import com.unity3d.ads.core.domain.AndroidTriggerInitializationCompletedRequest
import com.unity3d.ads.core.domain.AwaitInitialization
import com.unity3d.ads.core.domain.BuildHeaderBiddingToken
import com.unity3d.ads.core.domain.CacheFile
import com.unity3d.ads.core.domain.CheckForGameIdAndTestModeChanges
import com.unity3d.ads.core.domain.ClearCache
import com.unity3d.ads.core.domain.CommonAwaitInitialization
import com.unity3d.ads.core.domain.CommonCacheFile
import com.unity3d.ads.core.domain.CommonCheckForGameIdAndTestModeChanges
import com.unity3d.ads.core.domain.CommonClearCache
import com.unity3d.ads.core.domain.CommonCreateFile
import com.unity3d.ads.core.domain.CommonGetAdObject
import com.unity3d.ads.core.domain.CommonGetAdPlayer
import com.unity3d.ads.core.domain.CommonGetCacheDirectory
import com.unity3d.ads.core.domain.CommonGetFileExtensionFromUrl
import com.unity3d.ads.core.domain.CommonGetGameId
import com.unity3d.ads.core.domain.CommonGetHeaderBiddingToken
import com.unity3d.ads.core.domain.CommonGetInitializationState
import com.unity3d.ads.core.domain.CommonGetIsFileCache
import com.unity3d.ads.core.domain.CommonGetWebViewBridgeUseCase
import com.unity3d.ads.core.domain.CommonInitAwaitingGetHeaderBiddingToken
import com.unity3d.ads.core.domain.CommonSetGameId
import com.unity3d.ads.core.domain.CommonSetInitializationState
import com.unity3d.ads.core.domain.CommonShouldAllowInitialization
import com.unity3d.ads.core.domain.CommonValidateGameId
import com.unity3d.ads.core.domain.CreateFile
import com.unity3d.ads.core.domain.ExecuteAdViewerRequest
import com.unity3d.ads.core.domain.GetAdDataRefreshRequest
import com.unity3d.ads.core.domain.GetAdObject
import com.unity3d.ads.core.domain.GetAdPlayer
import com.unity3d.ads.core.domain.GetAdPlayerConfigRequest
import com.unity3d.ads.core.domain.GetAdRequest
import com.unity3d.ads.core.domain.GetAsyncHeaderBiddingToken
import com.unity3d.ads.core.domain.GetByteStringId
import com.unity3d.ads.core.domain.GetCacheDirectory
import com.unity3d.ads.core.domain.GetCachedAsset
import com.unity3d.ads.core.domain.GetClientInfo
import com.unity3d.ads.core.domain.GetFileExtensionFromUrl
import com.unity3d.ads.core.domain.GetGameId
import com.unity3d.ads.core.domain.GetHeaderBiddingToken
import com.unity3d.ads.core.domain.GetInitRequestPolicy
import com.unity3d.ads.core.domain.GetInitializationCompletedRequest
import com.unity3d.ads.core.domain.GetInitializationData
import com.unity3d.ads.core.domain.GetInitializationRequest
import com.unity3d.ads.core.domain.GetInitializationRequestPayload
import com.unity3d.ads.core.domain.GetInitializationState
import com.unity3d.ads.core.domain.GetIsFileCache
import com.unity3d.ads.core.domain.GetLatestWebViewConfiguration
import com.unity3d.ads.core.domain.GetLimitedSessionToken
import com.unity3d.ads.core.domain.GetOpenGLRendererInfo
import com.unity3d.ads.core.domain.GetOperativeEventRequestPolicy
import com.unity3d.ads.core.domain.GetOtherRequestPolicy
import com.unity3d.ads.core.domain.GetPrivacyUpdateRequest
import com.unity3d.ads.core.domain.GetRequestPolicy
import com.unity3d.ads.core.domain.GetSharedDataTimestamps
import com.unity3d.ads.core.domain.GetUniversalRequestForPayLoad
import com.unity3d.ads.core.domain.GetUniversalRequestSharedData
import com.unity3d.ads.core.domain.GetWebViewBridgeUseCase
import com.unity3d.ads.core.domain.HandleGatewayAdResponse
import com.unity3d.ads.core.domain.HandleGatewayInitializationResponse
import com.unity3d.ads.core.domain.HandleGatewayUniversalResponse
import com.unity3d.ads.core.domain.HandleInvocationsFromAdViewer
import com.unity3d.ads.core.domain.HandleOpenUrl
import com.unity3d.ads.core.domain.HttpClientProvider
import com.unity3d.ads.core.domain.InitializeBoldSDK
import com.unity3d.ads.core.domain.LegacyLoadUseCase
import com.unity3d.ads.core.domain.LegacyShowUseCase
import com.unity3d.ads.core.domain.Load
import com.unity3d.ads.core.domain.Refresh
import com.unity3d.ads.core.domain.RemoveUrlQuery
import com.unity3d.ads.core.domain.SendDiagnosticEvent
import com.unity3d.ads.core.domain.SendPrivacyUpdateRequest
import com.unity3d.ads.core.domain.SendWebViewClientErrorDiagnostics
import com.unity3d.ads.core.domain.SetGameId
import com.unity3d.ads.core.domain.SetInitializationState
import com.unity3d.ads.core.domain.ShouldAllowInitialization
import com.unity3d.ads.core.domain.TriggerInitializationCompletedRequest
import com.unity3d.ads.core.domain.TriggerInitializeListener
import com.unity3d.ads.core.domain.ValidateGameId
import com.unity3d.ads.core.domain.attribution.AndroidAttribution
import com.unity3d.ads.core.domain.events.AndroidGetTransactionData
import com.unity3d.ads.core.domain.events.CommonGetTransactionRequest
import com.unity3d.ads.core.domain.events.CommonUniversalRequestTtlValidator
import com.unity3d.ads.core.domain.events.DiagnosticEventObserver
import com.unity3d.ads.core.domain.events.EventObservers
import com.unity3d.ads.core.domain.events.GetDiagnosticEventBatchRequest
import com.unity3d.ads.core.domain.events.GetDiagnosticEventRequest
import com.unity3d.ads.core.domain.events.GetOperativeEventApi
import com.unity3d.ads.core.domain.events.GetOperativeEventRequest
import com.unity3d.ads.core.domain.events.GetTransactionData
import com.unity3d.ads.core.domain.events.GetTransactionRequest
import com.unity3d.ads.core.domain.events.HandleGatewayEventResponse
import com.unity3d.ads.core.domain.events.OperativeEventObserver
import com.unity3d.ads.core.domain.events.TransactionEventObserver
import com.unity3d.ads.core.domain.events.UniversalRequestEventSender
import com.unity3d.ads.core.domain.events.UniversalRequestTtlValidator
import com.unity3d.ads.core.domain.om.AndroidInitializeOMSDK
import com.unity3d.ads.core.domain.om.AndroidOmFinishSession
import com.unity3d.ads.core.domain.om.AndroidOmImpressionOccurred
import com.unity3d.ads.core.domain.om.AndroidOmInteraction
import com.unity3d.ads.core.domain.om.AndroidOmStartSession
import com.unity3d.ads.core.domain.om.CommonGetOmData
import com.unity3d.ads.core.domain.om.CommonIsOMActivated
import com.unity3d.ads.core.domain.om.GetOmData
import com.unity3d.ads.core.domain.om.InitializeOMSDK
import com.unity3d.ads.core.domain.om.IsOMActivated
import com.unity3d.ads.core.domain.om.OmFinishSession
import com.unity3d.ads.core.domain.om.OmImpressionOccurred
import com.unity3d.ads.core.domain.privacy.DeveloperConsentFlattenerRulesUseCase
import com.unity3d.ads.core.domain.privacy.FlattenerRulesUseCase
import com.unity3d.ads.core.domain.privacy.LegacyUserConsentFlattenerRulesUseCase
import com.unity3d.ads.core.domain.scar.AndroidFetchSignalsAndSendUseCase
import com.unity3d.ads.core.domain.scar.CommonScarEventReceiver
import com.unity3d.ads.core.domain.scar.FetchSignalsAndSendUseCase
import com.unity3d.ads.core.domain.scar.GetAndroidTokenEventRequest
import com.unity3d.ads.core.domain.scar.GetHbTokenEventRequest
import com.unity3d.ads.core.domain.scar.HandleAndroidGetTokenRequest
import com.unity3d.ads.core.domain.scar.HandleGetTokenRequest
import com.unity3d.ads.core.domain.scar.LoadScarAd
import com.unity3d.ads.core.domain.scar.ScarTimeHackFixer
import com.unity3d.ads.core.domain.work.BackgroundWorker
import com.unity3d.ads.core.domain.work.DiagnosticEventRequestWorkModifier
import com.unity3d.ads.core.utils.CommonCoroutineTimer
import com.unity3d.ads.core.utils.CoroutineTimer
import com.unity3d.ads.datastore.ByteStringStoreOuterClass
import com.unity3d.ads.gatewayclient.CommonGatewayClient
import com.unity3d.ads.gatewayclient.GatewayClient
import com.unity3d.services.SDKErrorHandler
import com.unity3d.services.ads.gmascar.GMA
import com.unity3d.services.ads.gmascar.GMAScarAdapterBridge
import com.unity3d.services.ads.gmascar.utils.GMAEventSender
import com.unity3d.services.ads.token.InMemoryTokenStorage
import com.unity3d.services.ads.token.TokenStorage
import com.unity3d.services.core.configuration.ConfigurationReader
import com.unity3d.services.core.device.VolumeChange
import com.unity3d.services.core.device.VolumeChangeContentObserver
import com.unity3d.services.core.domain.task.ConfigFileFromLocalStorage
import com.unity3d.services.core.domain.task.InitializeSDK
import com.unity3d.services.core.domain.task.InitializeStateComplete
import com.unity3d.services.core.domain.task.InitializeStateConfig
import com.unity3d.services.core.domain.task.InitializeStateConfigWithLoader
import com.unity3d.services.core.domain.task.InitializeStateCreate
import com.unity3d.services.core.domain.task.InitializeStateError
import com.unity3d.services.core.domain.task.InitializeStateLoadCache
import com.unity3d.services.core.domain.task.InitializeStateLoadWeb
import com.unity3d.services.core.domain.task.InitializeStateNetworkError
import com.unity3d.services.core.domain.task.InitializeStateReset
import com.unity3d.services.core.network.core.CronetEngineBuilderFactory
import com.unity3d.services.core.properties.ClientProperties
import com.unity3d.services.core.webview.bridge.IEventSender
import com.unity3d.services.core.webview.bridge.SharedInstances.webViewEventSender
import com.unity3d.services.store.StoreMonitor
import com.unity3d.services.store.StoreWebViewEventSender
import com.unity3d.services.store.core.GatewayStoreExceptionHandler
import com.unity3d.services.store.core.StoreEventListenerFactory
import com.unity3d.services.store.core.StoreExceptionHandler
import kotlinx.coroutines.CoroutineExceptionHandler
import kotlinx.coroutines.runBlocking

/**
 * Main service provider containing and instantiating required dependencies
 */
object ServiceProvider : IServiceProvider {
    const val NAMED_SDK: String = "sdk"
    const val NAMED_INIT_SCOPE: String = "init_scope"
    const val NAMED_LOAD_SCOPE: String = "load_scope"
    const val NAMED_SHOW_SCOPE: String = "show_scope"
    const val NAMED_GET_TOKEN_SCOPE: String = "get_token_scope"
    const val NAMED_TRANSACTION_SCOPE: String = "transaction_scope"
    const val NAMED_SCAR_SCOPE: String = "scar_scope"
    const val NAMED_OMID_SCOPE: String = "omid_scope"
    const val NAMED_INIT_REQ: String = "init_req"
    const val NAMED_OPERATIVE_REQ: String = "op_event_req"
    const val NAMED_OTHER_REQ: String = "other_req"
    const val NAMED_AD_REQ: String = "ad_req"
    const val NAMED_PUBLIC_JOB: String = "public_job"
    const val NAMED_LOCAL: String = "local"
    const val NAMED_REMOTE: String = "remote"

    const val LEGACY_PRIVACY_RULES = "legacy_privacy_rules"
    const val DEV_CONSENT_PRIVACY_RULES = "dev_consent_privacy_rules"

    // datastores
    const val DATA_STORE_GATEWAY_CACHE = "gateway_cache.pb"
    const val DATA_STORE_PRIVACY = "privacy.pb"
    const val DATA_STORE_PRIVACY_FSM = "privacy_fsm.pb"
    const val DATA_STORE_NATIVE_CONFIG = "native_configuration.pb"
    const val DATA_STORE_IAP_TRANSACTION = "iap_transaction.pb"
    const val DATA_STORE_UNIVERSAL_REQUEST = "universal_request.pb"
    const val DATA_STORE_GL_INFO = "glinfo.pb"
    const val DATA_STORE_WEBVIEW_CONFIG = "webview_config.pb"

    // preferences
    const val PREF_GL_INFO = "glinfo"

    // http
    const val GATEWAY_HOST = "gateway.unityads.unity3d.com"
    const val GATEWAY_PORT = 443
    const val CDN_CREATIVES_HOST = "cdn-creatives-cf-prd.acquire.unity3dusercontent.com"
    const val CDN_CREATIVES_PORT = 443
    const val HTTP_CACHE_DISK_SIZE = 5 * 1024 * 1024L // 5MiB
    const val HTTP_CLIENT_FETCH_TIMEOUT = 500L // 500ms
    const val SCAR_VERSION_FETCH_TIMEOUT = 5000L // 5s
    const val SCAR_SIGNALS_FETCH_TIMEOUT = 50000L // 50s

    const val MAIN_DISPATCHER = "main_dispatcher"
    const val DEFAULT_DISPATCHER = "default_dispatcher"
    const val IO_DISPATCHER = "io_dispatcher"

    private val serviceRegistry: IServicesRegistry = initialize()

    override fun getRegistry(): IServicesRegistry = serviceRegistry

    override fun initialize(): IServicesRegistry = registry {
        val moduleInstance = UnityAdsModule()
        single { ClientProperties.getApplicationContext() }
        single(MAIN_DISPATCHER) { moduleInstance.mainDispatcher() }
        single(DEFAULT_DISPATCHER) { moduleInstance.defaultDispatcher() }
        single(IO_DISPATCHER) { moduleInstance.ioDispatcher() }
        single { moduleInstance.sdkDispatchers() }
        single { moduleInstance.sdkMetrics() }
        factory(NAMED_INIT_SCOPE) {
            moduleInstance.initCoroutineScope(
                get(),
                get(NAMED_SDK),
                get(NAMED_PUBLIC_JOB)
            )
        }
        factory(NAMED_LOAD_SCOPE) {
            moduleInstance.loadCoroutineScope(
                get(),
                get(NAMED_SDK),
                get(NAMED_PUBLIC_JOB)
            )
        }
        factory(NAMED_SHOW_SCOPE) {
            moduleInstance.showCoroutineScope(
                get(),
                get(NAMED_SDK),
                get(NAMED_PUBLIC_JOB)
            )
        }
        factory(NAMED_TRANSACTION_SCOPE) {
            moduleInstance.transactionCoroutineScope(
                get(),
                get(NAMED_SDK),
                get(NAMED_PUBLIC_JOB)
            )
        }
        factory(NAMED_GET_TOKEN_SCOPE) {
            moduleInstance.getTokenCoroutineScope(
                get(),
                get(NAMED_SDK),
                get(NAMED_PUBLIC_JOB)
            )
        }
        factory(NAMED_SCAR_SCOPE) {
            moduleInstance.scarSignalsCoroutineScope(
                get(),
                get(NAMED_SDK),
                get(NAMED_PUBLIC_JOB)
            )
        }
        factory(NAMED_OMID_SCOPE) {
            moduleInstance.omidCoroutineScope(
                get(),
                get(NAMED_SDK),
                get(NAMED_PUBLIC_JOB)
            )
        }
        factory(NAMED_PUBLIC_JOB) { moduleInstance.publicApiJob(get()) }
        single<ByteStringDataSource>(DATA_STORE_GATEWAY_CACHE) { AndroidLegacyConfigStoreDataSource(get()) }
        single(DATA_STORE_PRIVACY) { moduleInstance.privacyDataStore(get(), get(IO_DISPATCHER)) }
        single(DATA_STORE_PRIVACY) { moduleInstance.privacyDataStore(get(DATA_STORE_PRIVACY)) }
        single(DATA_STORE_PRIVACY_FSM) { moduleInstance.privacyFsmDataStore(get(), get(IO_DISPATCHER)) }
        single(DATA_STORE_PRIVACY_FSM) { moduleInstance.privacyFsmDataStore(get(DATA_STORE_PRIVACY_FSM)) }
        single(DATA_STORE_NATIVE_CONFIG) {
            moduleInstance.nativeConfigurationDataStore(
                get(),
                get(IO_DISPATCHER)
            )
        }
        single(DATA_STORE_NATIVE_CONFIG) { moduleInstance.nativeConfigurationDataStore(get(DATA_STORE_NATIVE_CONFIG)) }
        single(DATA_STORE_GL_INFO) { moduleInstance.glInfoDataStore(get(), get(IO_DISPATCHER), get(PREF_GL_INFO)) }
        single(DATA_STORE_GL_INFO) { moduleInstance.glInfoDataStore(get(DATA_STORE_GL_INFO)) }
        single(DATA_STORE_UNIVERSAL_REQUEST) { moduleInstance.universalRequestDataStore(get(), get(IO_DISPATCHER)) }
        single(DATA_STORE_IAP_TRANSACTION) { moduleInstance.iapTransactionDataStore(get(), get(IO_DISPATCHER)) }
        single(DATA_STORE_IAP_TRANSACTION) { moduleInstance.iapTransactionDataStore(get(DATA_STORE_IAP_TRANSACTION)) }
        single(DATA_STORE_WEBVIEW_CONFIG) {
            moduleInstance.webViewConfigurationDataStore(
                get(),
                get(IO_DISPATCHER)
            )
        }
        single { moduleInstance.asyncTokenStorage(get(), get()) }
        single { moduleInstance.volumeChangeMonitor(get()) }
        single("PUBLIC") { moduleInstance.publicJsonStorage() }
        single("PRIVATE") { moduleInstance.privateJsonStorage() }
        single { moduleInstance.defaultNativeConfiguration() }
        single { moduleInstance.measurementService(get(), get()) }
        single { moduleInstance.topicsService(get(), get()) }
        single<CronetEngineBuilderFactory> { CronetEngineBuilderFactory() }
        single<HttpClientProvider> { AndroidHttpClientProvider(get(), get(), get(), get(), get(), get()) }
        single { runBlocking { get<HttpClientProvider>().invoke() } }
        single { AlternativeFlowReader(get(), get()) }
        single<TcfDataSource> { AndroidTcfDataSource() }
        single<TcfRepository> { AndroidTcfRepository(get()) }
        single<AndroidManifestIntPropertyReader> { AndroidManifestIntPropertyReader(get())}
        single<AndroidTestDataInfo> {AndroidTestDataInfo(get())}
        single { GameServerIdReader(get("PUBLIC")) }
        single<StoreDataSource> { AndroidStoreDataSource(get()) }
        single<AnalyticsDataSource> { com.unity3d.ads.core.data.datasource.AndroidAnalyticsDataSource() }
        single<DeveloperConsentDataSource> {
            AndroidDeveloperConsentDataSource(
                get(DEV_CONSENT_PRIVACY_RULES),
                get("PUBLIC")
            )
        }
        single<DynamicDeviceInfoDataSource> {
            AndroidDynamicDeviceInfoDataSource(
                get(),
                get()
            )
        }
        single<LegacyUserConsentDataSource> {
            AndroidLegacyUserConsentDataSource(
                get(LEGACY_PRIVACY_RULES),
                get("PRIVATE")
            )
        }
        single<LifecycleDataSource> { AndroidLifecycleDataSource() }
        single<CacheDataSource>(NAMED_LOCAL) { AndroidLocalCacheDataSource(get(), get()) }
        single<CreateFile> { CommonCreateFile() }
        single<GetFileExtensionFromUrl> { CommonGetFileExtensionFromUrl(get()) }
        single<RemoveUrlQuery> { AndroidRemoveUrlQuery() }
        single<MediationDataSource> {
            AndroidMediationDataSource(
                get("PUBLIC")
            )
        }
        single<PrivacyDeviceInfoDataSource> {
            AndroidPrivacyDeviceInfoDataSource(
                get()
            )
        }
        single<CacheDataSource>(NAMED_REMOTE) {
            AndroidRemoteCacheDataSource(
                get(),
                get(),
                get()
            )
        }
        single<StaticDeviceInfoDataSource> {
            AndroidStaticDeviceInfoDataSource(
                get(),
                get(DATA_STORE_GL_INFO),
                get(),
                get()
            )
        }
        single<DataMigration<ByteStringStoreOuterClass.ByteStringStore>>(PREF_GL_INFO) {
            FetchGLInfoDataMigration(
                get()
            )
        }
        single { UniversalRequestDataSource(get(DATA_STORE_UNIVERSAL_REQUEST)) }
        single { WebviewConfigurationDataSource(get(DATA_STORE_WEBVIEW_CONFIG)) }
        single<OmidManager> { AndroidOmidManager() }
        single<SDKPropertiesManager> { AndroidSDKPropertiesManager() }
        single<com.unity3d.ads.core.data.manager.StorageManager> { AndroidStorageManager() }
        single {
            TransactionEventManager(
                get(NAMED_TRANSACTION_SCOPE),
                get(),
                get(),
                get(),
                get(),
                get(DATA_STORE_IAP_TRANSACTION),
                get()
            )
        }
        single<AdRepository> { AndroidAdRepository() }
        single<CacheRepository> {
            AndroidCacheRepository(
                get(IO_DISPATCHER),
                get(),
                get(),
                get(NAMED_REMOTE),
                get()
            )
        }
        single<GetCacheDirectory> { CommonGetCacheDirectory() }
        single<CampaignRepository> {
            AndroidCampaignRepository(
                get()
            )
        }
        single<DeveloperConsentRepository> {
            AndroidDeveloperConsentRepository(
                get()
            )
        }
        single<DeviceInfoRepository> {
            AndroidDeviceInfoRepository(
                get(),
                get(),
                get(),
                get()
            )
        }
        single<DiagnosticEventRepository> { AndroidDiagnosticEventRepository(get(), get(), get(DEFAULT_DISPATCHER)) }
        single<LegacyUserConsentRepository> {
            AndroidLegacyUserConsentRepository(
                get()
            )
        }
        single<MediationRepository> {
            AndroidMediationRepository(
                get()
            )
        }
        single<OpenMeasurementRepository> {
            AndroidOpenMeasurementRepository(
                get(MAIN_DISPATCHER),
                get()
            )
        }
        single<SessionRepository> {
            AndroidSessionRepository(
                get(DATA_STORE_GATEWAY_CACHE),
                get(DATA_STORE_PRIVACY),
                get(DATA_STORE_PRIVACY_FSM),
                get(DATA_STORE_NATIVE_CONFIG),
                get(),
                get(IO_DISPATCHER),
                get()
            )
        }
        single<TransactionEventRepository> { AndroidTransactionEventRepository() }
        single { OperativeEventRepository() }
        single<ExecuteAdViewerRequest> {
            AndroidExecuteAdViewerRequest(
                get(IO_DISPATCHER),
                get()
            )
        }
        single<GetByteStringId> { AndroidGenerateByteStringId() }
        single<HandleOpenUrl> { AndroidHandleOpenUrl(get()) }
        single<Refresh> {
            AndroidRefresh(
                get(DEFAULT_DISPATCHER),
                get(),
                get(NAMED_AD_REQ),
                get()
            )
        }
        single<SendDiagnosticEvent> {
            AndroidSendDiagnosticEvent(
                get(),
                get()
            )
        }
        single<SendWebViewClientErrorDiagnostics> {
            AndroidSendWebViewClientErrorDiagnostics(
                get()
            )
        }
        single<com.unity3d.ads.core.domain.Show> { AndroidShow(get(), get(), get()) }
        single<CacheFile> {
            CommonCacheFile(
                get(),
                get()
            )
        }
        single<ClearCache> {
            CommonClearCache(
                get(),
                get()
            )
        }
        single<GetAdObject> { CommonGetAdObject(get()) }
        factory<GetHeaderBiddingToken> {
            CommonGetHeaderBiddingToken(
                get(),
                get(),
                get()
            )
        }
        factory<BuildHeaderBiddingToken> {
            AndroidBuildHeaderBiddingToken(
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
            )
        }
        single<GetInitializationData> {
            AndroidGetInitializationData(
                get(),
                get()
            )
        }
        single<GetInitializationRequestPayload> {
            AndroidGetInitializationRequestPayload(
                get(),
                get(),
                get(),
                get(),
            )
        }
        single<GetInitializationState> {
            CommonGetInitializationState(
                get(),
                get()
            )
        }
        single<GetIsFileCache> {
            CommonGetIsFileCache(
                get(),
                get()
            )
        }
        single<SetInitializationState> {
            CommonSetInitializationState(
                get(),
                get()
            )
        }
        single<GetRequestPolicy>(NAMED_AD_REQ) {
            AndroidGetAdRequestPolicy(
                get()
            )
        }
        single<GetAdDataRefreshRequest> {
            AndroidGetAdDataRefreshRequest(
                get(),
                get(),
                get(),
                get()
            )
        }
        single<GetAdPlayerConfigRequest> {
            AndroidGetAdPlayerConfigRequest(
                get()
            )
        }
        single { AndroidGetAdPlayerContext(get(), get()) }
        single<GetAdRequest> {
            AndroidGetAdRequest(
                get(),
                get(),
                get(),
                get(),
                get(),
                get()
            )
        }
        single<GetHbTokenEventRequest> {
            GetAndroidTokenEventRequest()
        }
        single<CommonScarEventReceiver> { CommonScarEventReceiver(get(NAMED_SCAR_SCOPE)) }
        single<GMAScarAdapterBridge> { GMA.getInstance(GMAEventSender(get<CommonScarEventReceiver>())).bridge }
        single { ScarTimeHackFixer(get()) }
        single<ScarManager> { AndroidScarManager(get(), get(), get()) }
        single<FetchSignalsAndSendUseCase> {
            AndroidFetchSignalsAndSendUseCase(
                get(NAMED_SCAR_SCOPE),
                get(),
                get(),
                get(),
                get()
            )
        }
        single { LoadScarAd(get()) }
        single<HandleGetTokenRequest> {
            HandleAndroidGetTokenRequest(get(), get(), get(NAMED_OTHER_REQ), get())
        }
        single<GetClientInfo> {
            AndroidGetClientInfo(
                get(),
                get(),
                get(),
                get()
            )
        }
        single<GetInitializationCompletedRequest> {
            AndroidGetInitializationCompletedRequest(
                get(),
                get()
            )
        }
        single<GetInitializationRequest> {
            AndroidGetInitializationRequest(
                get(),
                get(),
            )
        }
        single<GetLimitedSessionToken> {
            AndroidGetLimitedSessionToken(
                get(),
                get(),
                get()
            )
        }
        single<GetOpenGLRendererInfo> {
            AndroidGetOpenGLRendererInfo(
                get()
            )
        }
        single<GetSharedDataTimestamps> { AndroidGetSharedDataTimestamps() }
        single<GetUniversalRequestForPayLoad> {
            AndroidGetUniversalRequestForPayLoad(
                get()
            )
        }
        single<GetUniversalRequestSharedData> {
            AndroidGetUniversalRequestSharedData(
                get(),
                get(),
                get(),
                get(),
                get()
            )
        }
        single { GetCachedAsset(get(), get()) }
        single<GetWebViewBridgeUseCase> {
            CommonGetWebViewBridgeUseCase(
                get(DEFAULT_DISPATCHER),
                get(),
            )
        }
        single<GetRequestPolicy>(NAMED_INIT_REQ) {
            GetInitRequestPolicy(
                get()
            )
        }
        single { GetLatestWebViewConfiguration(get()) }
        single<GetRequestPolicy>(NAMED_OPERATIVE_REQ) {
            GetOperativeEventRequestPolicy(
                get()
            )
        }
        single<GetRequestPolicy>(NAMED_OTHER_REQ) {
            GetOtherRequestPolicy(
                get()
            )
        }
        single { GetPrivacyUpdateRequest(get()) }
        single<HandleGatewayInitializationResponse> {
            AndroidHandleGatewayInitializationResponse(
                get(),
                get(),
                get(),
                get(NAMED_INIT_SCOPE)
            )
        }
        single<HandleGatewayUniversalResponse> {
            AndroidHandleGatewayUniversalResponse(
                get(),
                get()
            )
        }
        single<InitializeBoldSDK> {
            AndroidInitializeBoldSDK(
                get(DEFAULT_DISPATCHER),
                get(),
                get(),
                get(NAMED_INIT_REQ),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get()
            )
        }
        factory {
            LegacyShowUseCase(
                get(MAIN_DISPATCHER),
                get(),
                get(),
                get(),
                get(),
                get(),
                get()
            )
        }
        single { SendPrivacyUpdateRequest(get(), get(NAMED_OTHER_REQ), get()) }
        single<TriggerInitializationCompletedRequest> {
            AndroidTriggerInitializationCompletedRequest(
                get(),
                get(NAMED_INIT_REQ),
                get(),
                get()
            )
        }
        single { TriggerInitializeListener(get(MAIN_DISPATCHER)) }
        single {
            DiagnosticEventObserver(
                get(),
                get(),
                get(DEFAULT_DISPATCHER),
                get(),
                get(),
                get()
            )
        }
        single { EventObservers(get(), get(), get()) }
        single<GetTransactionData> {
            AndroidGetTransactionData(
                get()
            )
        }
        single<GetTransactionRequest> {
            CommonGetTransactionRequest(
                get()
            )
        }
        single { GetDiagnosticEventBatchRequest() }
        single { GetDiagnosticEventRequest(get()) }
        single { GetOperativeEventApi(get(), get()) }
        single { GetOperativeEventRequest(get(), get(), get(), get()) }
        single<HandleGatewayEventResponse> { com.unity3d.ads.core.domain.events.AndroidHandleGatewayEventResponse() }
        single {
            OperativeEventObserver(
                get(),
                get(DEFAULT_DISPATCHER),
                get(),
                get(),
                get()
            )
        }
        single {
            TransactionEventObserver(
                get(),
                get(DEFAULT_DISPATCHER),
                get(),
                get(),
                get(NAMED_OTHER_REQ),
                get(DATA_STORE_IAP_TRANSACTION)
            )
        }
        single<UniversalRequestTtlValidator> { CommonUniversalRequestTtlValidator() }
        single { UniversalRequestEventSender(get(), get(), get()) }
        single<OmFinishSession> {
            AndroidOmFinishSession(
                get(),
                get()
            )
        }
        single<OmImpressionOccurred> {
            AndroidOmImpressionOccurred(
                get(),
                get()
            )
        }
        single<AndroidOmInteraction> {
            AndroidOmStartSession(
                get(),
                get()
            )
        }
        single<GetOmData> { CommonGetOmData(get()) }
        single<IsOMActivated> {
            CommonIsOMActivated(
                get()
            )
        }
        single<InitializeOMSDK> {
            AndroidInitializeOMSDK(
                get(),
                get(),
                get(),
                get()
            )
        }
        single<FlattenerRulesUseCase>(DEV_CONSENT_PRIVACY_RULES) { DeveloperConsentFlattenerRulesUseCase() }
        single<FlattenerRulesUseCase>(LEGACY_PRIVACY_RULES) { LegacyUserConsentFlattenerRulesUseCase() }
        single { BackgroundWorker(get()) }
        single { DiagnosticEventRequestWorkModifier(get(), get()) }
        single<GatewayClient> {
            CommonGatewayClient(
                get(),
                get(),
                get(),
                get()
            )
        }
        single<CoroutineExceptionHandler>(NAMED_SDK) {
            SDKErrorHandler(
                get(IO_DISPATCHER),
                get(),
                get(),
                get()
            )
        }
        single<TokenStorage> { InMemoryTokenStorage() }
        single<VolumeChange> { VolumeChangeContentObserver() }
        single { ConfigFileFromLocalStorage(get()) }
        single {
            InitializeSDK(
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get()
            )
        }
        single { InitializeStateComplete(get()) }
        single { InitializeStateConfig(get(), get()) }
        single {
            InitializeStateConfigWithLoader(
                get(),
                get(),
                get(),
                get()
            )
        }
        single { InitializeStateCreate(get()) }
        single { InitializeStateError(get()) }
        single { InitializeStateLoadCache(get()) }
        single { InitializeStateLoadWeb(get(), get(), get()) }
        single { InitializeStateReset(get()) }
        single { StoreMonitor(get()) }
        single { StoreWebViewEventSender(get()) }
        single<StoreExceptionHandler> { GatewayStoreExceptionHandler() }
        single { StoreEventListenerFactory(get()) }
        single { ConfigurationReader() }
        single { AndroidAttribution(get(), get(), get()) }
        factory { AdPlayerScope(get(DEFAULT_DISPATCHER)) }
        factory {
            AndroidWebViewClient(
                get(),
                get(),
                get()
            )
        }
        factory {
            AndroidGetWebViewContainerUseCase(
                get(),
                get(),
                get(),
                get(MAIN_DISPATCHER),
                get(DEFAULT_DISPATCHER)
            )
        }
        factory<Load> {
            AndroidLoad(
                get(DEFAULT_DISPATCHER),
                get(),
                get(),
                get(NAMED_AD_REQ),
                get(),
                get(),
                get(),
                get()
            )
        }
        factory<AwaitInitialization> {
            CommonAwaitInitialization(
                get()
            )
        }
        factory<GetAsyncHeaderBiddingToken> {
            CommonInitAwaitingGetHeaderBiddingToken(
                get(),
                get(),
                get(),
                get(),
                get()
            )
        }
        factory<GetAdPlayer> {
            CommonGetAdPlayer(
                get(),
                get(),
                get(),
                get(),
                get(DEFAULT_DISPATCHER),
                get<AdPlayerScope>(),
                get(),
                get()
            )
        }
        factory<HandleGatewayAdResponse> {
            AndroidHandleGatewayAdResponse(
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
                get(),
            )
        }
        factory { HandleInvocationsFromAdViewer() }
        factory {
            LegacyLoadUseCase(
                get(MAIN_DISPATCHER),
                get(),
                get(),
                get(),
                get(),
                get(),
                get()
            )
        }
        factory { InitializeStateNetworkError(get()) }
        factory<CoroutineTimer> { CommonCoroutineTimer(get(DEFAULT_DISPATCHER)) }
        single<IEventSender> { webViewEventSender }
        single<SetGameId> { CommonSetGameId(get()) }
        single<GetGameId> { CommonGetGameId(get()) }
        single<ValidateGameId> { CommonValidateGameId(get(), get()) }
        single<GetWebViewCacheAssetLoader> { CommonGetWebViewCacheAssetLoader(get(), get()) }
        single<ShouldAllowInitialization> { CommonShouldAllowInitialization(get(), get(), get(), get(), get()) }
        single<CheckForGameIdAndTestModeChanges> { CommonCheckForGameIdAndTestModeChanges(get(), get()) }
    }
}
